/*
 * Decompiled with CFR 0.152.
 */
package com.unixkitty.timecontrol.handler;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.unixkitty.timecontrol.Config;
import com.unixkitty.timecontrol.Numbers;
import com.unixkitty.timecontrol.TimeControl;
import com.unixkitty.timecontrol.handler.TimeHandler;
import com.unixkitty.timecontrol.network.ModNetworkDispatcher;
import com.unixkitty.timecontrol.network.packet.GamerulesS2CPacket;
import com.unixkitty.timecontrol.network.packet.TimeS2CPacket;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="timecontrol")
public final class ServerTimeHandler
extends TimeHandler {
    private static final ServerTimeHandler instance = new ServerTimeHandler();
    private static final Logger log = LogManager.getLogger((String)ServerTimeHandler.class.getSimpleName());
    private static final String time_string = "time";
    private static final String add_string = "add";
    private static final String set_string = "set";
    private int lastMinute = 0;
    private boolean wasDaytime = true;
    private int dayMinutes = 0;
    private int nightMinutes = 0;
    private long lastCustomtime = this.customtime;

    private ServerTimeHandler() {
    }

    @Override
    public void tick(@Nonnull Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)Config.sync_to_system_time.get()).booleanValue()) {
                if (!serverLevel.f_46443_ && serverLevel.m_7654_().m_129921_() % (Integer)Config.sync_to_system_time_rate.get() == 0) {
                    this.syncTimeWithSystem(serverLevel);
                }
            } else {
                long worldtime = serverLevel.m_46468_();
                boolean isDaytime = Numbers.isDaytime(worldtime);
                if (isDaytime != this.wasDaytime) {
                    this.reset(worldtime);
                    this.wasDaytime = isDaytime;
                }
                if (serverLevel.m_46469_().m_46207_(TimeControl.DO_DAYLIGHT_CYCLE_TC)) {
                    if (this.areAllPlayersAsleep(serverLevel)) {
                        ((GameRules.BooleanValue)serverLevel.m_46469_().m_46170_(GameRules.f_46140_)).m_46246_(true, serverLevel.m_7654_());
                    }
                    this.lastCustomtime = ++this.customtime;
                    Numbers.setWorldtime((Level)serverLevel, this.customtime, this.multiplier);
                }
                if (serverLevel.m_7654_().m_129921_() % 20 == 0) {
                    if (this.dayMinutes != (Integer)Config.day_length_seconds.get() || this.nightMinutes != (Integer)Config.night_length_seconds.get()) {
                        ServerTimeHandler.update(serverLevel.m_46468_());
                    }
                    this.updateClientsTime();
                    ModNetworkDispatcher.send(new GamerulesS2CPacket(serverLevel), (ResourceKey<Level>)serverLevel.m_46472_());
                    if (((Boolean)Config.debug.get()).booleanValue()) {
                        long updatedWorldtime = serverLevel.m_46468_();
                        log.debug("{} Server time update: {} -> {} ({} -> {}) (day {}) | multiplier: {}", (Object)Numbers.getProgressString(updatedWorldtime), (Object)worldtime, (Object)updatedWorldtime, (Object)this.lastCustomtime, (Object)this.customtime, (Object)(updatedWorldtime / 24000L), (Object)this.multiplier);
                    }
                }
            }
        }
    }

    @Override
    public void update(long customtime, double multiplier) {
        super.update(customtime, multiplier);
        this.updateClientsTime();
    }

    private double getMultiplier() {
        return this.multiplier;
    }

    private long getCustomtime() {
        return this.customtime;
    }

    private boolean areAllPlayersAsleep(ServerLevel level) {
        int l = level.m_46469_().m_46215_(GameRules.f_151486_);
        return level.f_143245_.m_144002_(l) && level.f_143245_.m_144004_(l, level.m_6907_());
    }

    private void reset(long worldtime) {
        this.update(Numbers.getCustomTime(worldtime), Numbers.getMultiplier(worldtime));
    }

    private void syncTimeWithSystem(ServerLevel level) {
        LocalDateTime now = LocalDateTime.now();
        int minute = now.getMinute();
        if (minute != this.lastMinute) {
            int day;
            long worldTime = level.m_46468_();
            int hour = now.getHour();
            int _day = day = now.getDayOfYear();
            int _hour = hour;
            int _minute = minute;
            double timeOffset = (Double)Config.sync_to_system_time_offset.get();
            if (timeOffset != 0.0) {
                int offsetMinutes = (int)(timeOffset * 60.0);
                LocalDateTime adjustedDateTime = now.plusMinutes(offsetMinutes);
                if (adjustedDateTime.getDayOfYear() != day) {
                    day = adjustedDateTime.getDayOfYear();
                }
                hour = adjustedDateTime.getHour();
                minute = adjustedDateTime.getMinute();
            }
            long time = Numbers.getSystemtimeTicks(hour, minute, day);
            this.lastMinute = _minute;
            level.m_8615_(time);
            if (((Boolean)Config.debug.get()).booleanValue()) {
                log.debug("System time update: {} -> {} | day {}, {} | system: day {}, {}, offset: {}", (Object)worldTime, (Object)time, (Object)day, (Object)String.format("%02d:%02d", hour, minute), (Object)_day, (Object)String.format("%02d:%02d", _hour, _minute), (Object)timeOffset);
            }
        }
    }

    private void updateClientsTime() {
        ModNetworkDispatcher.send(new TimeS2CPacket(this.customtime, this.multiplier), (ResourceKey<Level>)Level.f_46428_);
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor;
        if (TimeControl.DO_DAYLIGHT_CYCLE_TC != null && (levelAccessor = event.getLevel()) instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46140_)).m_46246_(false, level.m_7654_());
            if (!((Boolean)Config.sync_to_system_time.get()).booleanValue()) {
                ServerTimeHandler.update(level.m_46468_());
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && event.level.m_46472_() == Level.f_46428_) {
            instance.tick(event.level);
        }
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        CommandContext context;
        CommandSourceStack sender = (CommandSourceStack)event.getParseResults().getContext().getSource();
        ServerLevel level = sender.m_81372_();
        if (TimeControl.DO_DAYLIGHT_CYCLE_TC != null && event.getException() == null && event.getParseResults().getReader().getString().contains(time_string) && level.m_46472_() == Level.f_46428_ && (context = event.getParseResults().getContext().build(event.getParseResults().getReader().getString())).hasNodes() && ((ParsedCommandNode)context.getNodes().get(0)).getNode().getName().equals(time_string) && context.getNodes().size() == 3) {
            String action = ((ParsedCommandNode)context.getNodes().get(1)).getNode().getName();
            if (!action.equals(set_string) && !action.equals(add_string)) {
                return;
            }
            if (((Boolean)Config.sync_to_system_time.get()).booleanValue()) {
                sender.m_81352_(new CommandRuntimeException((Component)Component.m_237110_((String)"commands.timecontrol.change_time_when_system", (Object[])new Object[]{action, time_string})).m_79226_());
                event.setCanceled(true);
                return;
            }
            String argument = ((ParsedCommandNode)context.getNodes().get(2)).getNode().getName();
            Integer time = null;
            switch (argument) {
                case "day": {
                    time = 1000;
                    break;
                }
                case "noon": {
                    time = 6000;
                    break;
                }
                case "night": {
                    time = 13000;
                    break;
                }
                case "midnight": {
                    time = 18000;
                    break;
                }
                case "time": {
                    try {
                        time = IntegerArgumentType.getInteger((CommandContext)context, (String)time_string);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (((Boolean)Config.debug.get()).booleanValue()) {
                TimeControl.LOG.debug("Caught time command: /time " + action + " " + (Serializable)(time == null ? argument : time));
            }
            if (time != null) {
                ServerTimeHandler.update(action.equals(set_string) ? (long)time.intValue() : level.m_46468_() + (long)time.intValue());
                Numbers.setWorldtime((Level)level, instance.getCustomtime(), instance.getMultiplier());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onSleepFinished(SleepFinishedTimeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            if (ModList.get().isLoaded("comforts")) {
                boolean[] activeHammock = new boolean[]{true};
                for (Player player : event.getLevel().m_6907_()) {
                    player.m_21257_().ifPresent(bedPos -> {
                        if (player.m_36317_() && !Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)level.m_8055_(bedPos).m_60734_())).toString().startsWith("comforts:hammock_")) {
                            activeHammock[0] = false;
                        }
                    });
                    if (activeHammock[0]) continue;
                    break;
                }
                if (activeHammock[0] && level.m_46461_()) {
                    long t = level.m_46468_() + 24000L - (level.m_46468_() + 24000L) % 24000L - 12001L;
                    event.setTimeAddition(t);
                    ServerTimeHandler.update(t);
                }
            }
            if (level.m_46469_().m_46207_(TimeControl.DO_DAYLIGHT_CYCLE_TC)) {
                ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46140_)).m_46246_(false, level.m_7654_());
            }
        }
    }

    public static void update(long worldtime) {
        instance.update(Numbers.getCustomTime(worldtime), Numbers.getMultiplier(worldtime));
        ServerTimeHandler.instance.dayMinutes = (Integer)Config.day_length_seconds.get();
        ServerTimeHandler.instance.nightMinutes = (Integer)Config.night_length_seconds.get();
    }
}

