/*
 * Decompiled with CFR 0.152.
 */
package com.unixkitty.timecontrol.handler;

import com.unixkitty.timecontrol.Config;
import com.unixkitty.timecontrol.Numbers;
import com.unixkitty.timecontrol.TimeControl;
import com.unixkitty.timecontrol.handler.TimeHandler;
import com.unixkitty.timecontrol.network.packet.BasePacket;
import com.unixkitty.timecontrol.network.packet.ConfigS2CPacket;
import com.unixkitty.timecontrol.network.packet.GamerulesS2CPacket;
import com.unixkitty.timecontrol.network.packet.TimeS2CPacket;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="timecontrol", value={Dist.CLIENT})
public final class ClientTimeHandler
extends TimeHandler {
    private static final TimeHandler instance = new ClientTimeHandler();
    private static final Logger log = LogManager.getLogger((String)ClientTimeHandler.class.getSimpleName());
    private int debugLogDelay = 0;

    private ClientTimeHandler() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.m_91087_().f_91073_ != null && !Minecraft.m_91087_().m_91104_()) {
            instance.tick((Level)Minecraft.m_91087_().f_91073_);
        }
    }

    public static void handlePacket(BasePacket packet) {
        if (packet instanceof TimeS2CPacket) {
            TimeS2CPacket message = (TimeS2CPacket)packet;
            instance.update(message.customtime, message.multiplier);
        } else if (packet instanceof GamerulesS2CPacket) {
            GamerulesS2CPacket message = (GamerulesS2CPacket)packet;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46140_)).m_46246_(message.vanillaRuleValue, null);
                ((GameRules.BooleanValue)level.m_46469_().m_46170_(TimeControl.DO_DAYLIGHT_CYCLE_TC)).m_46246_(message.modRuleValue, null);
            }
        } else if (packet instanceof ConfigS2CPacket) {
            ConfigS2CPacket message = (ConfigS2CPacket)packet;
            Config.day_length_seconds.set((Object)message.day_length_seconds);
            Config.night_length_seconds.set((Object)message.night_length_seconds);
            Config.sync_to_system_time_rate.set((Object)message.sync_to_system_time_rate);
            Config.sync_to_system_time.set((Object)message.sync_to_system_time);
            Config.sync_to_system_time_offset.set((Object)message.sync_to_system_time_offset);
        }
    }

    @Override
    public void tick(@Nonnull Level level) {
        if (!((Boolean)Config.sync_to_system_time.get()).booleanValue() && level.m_46472_() == Level.f_46428_) {
            boolean shouldLog;
            this.debugLogDelay = (this.debugLogDelay + 1) % 20;
            boolean bl = shouldLog = this.debugLogDelay == 0 && (Boolean)Config.clientDebug.get() != false;
            if (this.multiplier == 0.0) {
                if (shouldLog) {
                    log.debug("Waiting for server time packet...");
                }
                return;
            }
            if (level.m_46469_().m_46207_(TimeControl.DO_DAYLIGHT_CYCLE_TC)) {
                Numbers.setWorldtime(level, ++this.customtime, this.multiplier);
            }
            if (shouldLog) {
                long worldtime = level.m_46468_();
                log.debug("Client time: {} | multiplier: {} | gamerules: {}, {}", (Object)worldtime, (Object)this.multiplier, (Object)level.m_46469_().m_46207_(GameRules.f_46140_), (Object)level.m_46469_().m_46207_(TimeControl.DO_DAYLIGHT_CYCLE_TC));
            }
        }
    }
}

