/*
 * Decompiled with CFR 0.152.
 */
package com.unixkitty.timecontrol;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.unixkitty.timecontrol.Config;
import com.unixkitty.timecontrol.Numbers;
import com.unixkitty.timecontrol.network.ModNetworkDispatcher;
import com.unixkitty.timecontrol.network.packet.ConfigS2CPacket;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class TimeControlCommand {
    private static final String value_string = "value";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"timecontrol").requires(source -> source.m_6761_(2));
        TimeControlCommand.registerCommand("day_length_seconds", IntegerArgumentType.integer((int)1, (int)10737360), Config.day_length_seconds, (LiteralArgumentBuilder<CommandSourceStack>)command);
        TimeControlCommand.registerCommand("night_length_seconds", IntegerArgumentType.integer((int)1, (int)10737360), Config.night_length_seconds, (LiteralArgumentBuilder<CommandSourceStack>)command);
        TimeControlCommand.registerCommand("sync_to_system_time", BoolArgumentType.bool(), Config.sync_to_system_time, (LiteralArgumentBuilder<CommandSourceStack>)command);
        TimeControlCommand.registerCommand("sync_to_system_time_rate", IntegerArgumentType.integer((int)1, (int)864000), Config.sync_to_system_time_rate, (LiteralArgumentBuilder<CommandSourceStack>)command);
        TimeControlCommand.registerCommand("sync_to_system_time_offset", DoubleArgumentType.doubleArg((double)-23.0, (double)23.0), Config.sync_to_system_time_offset, (LiteralArgumentBuilder<CommandSourceStack>)command);
        dispatcher.register(command);
    }

    private static void registerCommand(String name, ArgumentType<?> argument, Supplier<?> configValueSupplier, LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)name).then(Commands.m_82129_((String)value_string, argument).executes(context -> TimeControlCommand.setValue((CommandContext<CommandSourceStack>)context, name)))).executes(context -> TimeControlCommand.sendFeedback((CommandContext<CommandSourceStack>)context, name, configValueSupplier.get(), false)));
    }

    private static int setValue(CommandContext<CommandSourceStack> context, String name) {
        Comparable<Boolean> value = switch (name) {
            case "sync_to_system_time" -> BoolArgumentType.getBool(context, (String)value_string);
            case "sync_to_system_time_offset" -> Double.valueOf(DoubleArgumentType.getDouble(context, (String)value_string));
            default -> Integer.valueOf(IntegerArgumentType.getInteger(context, (String)value_string));
        };
        switch (name) {
            case "day_length_seconds": {
                Config.day_length_seconds.set((Object)((Integer)value));
                break;
            }
            case "night_length_seconds": {
                Config.night_length_seconds.set((Object)((Integer)value));
                break;
            }
            case "sync_to_system_time_rate": {
                Config.sync_to_system_time_rate.set((Object)((Integer)value));
                break;
            }
            case "sync_to_system_time": {
                Config.sync_to_system_time.set((Object)value);
                break;
            }
            case "sync_to_system_time_offset": {
                if (Numbers.TIME_SHIFT_LIST.contains(value)) {
                    Config.sync_to_system_time_offset.set((Object)((Double)value));
                    break;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.timecontrol.sync_to_system_time_offset"));
                return 2;
            }
        }
        ModNetworkDispatcher.send(new ConfigS2CPacket());
        TimeControlCommand.sendFeedback(context, name, value, true);
        return 0;
    }

    private static int sendFeedback(CommandContext<CommandSourceStack> context, String valueName, Object value, boolean allowLogging) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)("commands.timecontrol." + (allowLogging ? "set" : "query")), (Object[])new Object[]{valueName, value}), allowLogging);
        return 0;
    }
}

