/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.items;

import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.items.LighterItemRenderer;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.content.equipment.armor.CapacityEnchantment;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.ModList;

public class LighterItem
extends Item
implements CapacityEnchantment.ICapacityEnchantable {
    public LighterItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, components, tooltipFlag);
        if (stack.m_41783_() != null) {
            CompoundTag tankCompound = stack.m_41783_().m_128469_("Fluid");
            FluidStack fStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tankCompound);
            if (fStack.isEmpty()) {
                components.add((Component)Component.m_237115_((String)"createdieselgenerators.tooltip.empty").m_130940_(ChatFormatting.GRAY));
                return;
            }
            components.add((Component)Lang.fluidName((FluidStack)fStack).component().m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)Lang.number((double)fStack.getAmount()).style(ChatFormatting.GOLD).component()).m_7220_((Component)Component.m_237115_((String)"create.generic.unit.millibuckets").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)" / ")).m_7220_((Component)Lang.number((double)((Integer)ConfigRegistry.TOOL_CAPACITY.get() + stack.getEnchantmentLevel((Enchantment)AllEnchantments.CAPACITY.get()) * (Integer)ConfigRegistry.TOOL_CAPACITY_ENCHANTMENT.get())).style(ChatFormatting.GRAY).component()).m_7220_((Component)Component.m_237115_((String)"create.generic.unit.millibuckets").m_130940_(ChatFormatting.GRAY)));
            return;
        }
        components.add((Component)Component.m_237115_((String)"createdieselgenerators.tooltip.empty").m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == AllEnchantments.CAPACITY.get()) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int m_142159_(ItemStack stack) {
        return 0xEFEFEF;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        CompoundTag tankCompound;
        FluidStack fStack;
        if (stack.m_41783_() != null && FuelTypeManager.getGeneratedSpeed((fStack = FluidStack.loadFluidStackFromNBT((CompoundTag)(tankCompound = stack.m_41783_().m_128469_("Fluid")))).getFluid()) == 0.0f && stack.m_41783_().m_128451_("Type") == 2) {
            stack.m_41783_().m_128405_("Type", 1);
        }
        super.m_6883_(stack, level, entity, p_41407_, p_41408_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.m_21120_(hand);
        CompoundTag tag = stackInHand.m_41783_();
        level.m_5594_(player, player.m_20183_(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
        if (tag == null) {
            stackInHand.m_41700_("Type", (Tag)IntTag.m_128679_((int)1));
            return InteractionResultHolder.m_19090_((Object)stackInHand);
        }
        if (tag.m_128451_("Type") == 0) {
            if (player.m_6144_()) {
                tag.m_128405_("Type", 1);
                return InteractionResultHolder.m_19090_((Object)stackInHand);
            }
            CompoundTag tankCompound = stackInHand.m_41783_().m_128469_("Fluid");
            FluidStack fStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tankCompound);
            tag.m_128405_("Type", FuelTypeManager.getGeneratedSpeed(fStack.getFluid()) == 0.0f ? 1 : 2);
            if (FuelTypeManager.getGeneratedSpeed(fStack.getFluid()) != 0.0f && stackInHand.m_41783_().m_128451_("Type") == 2) {
                fStack.setAmount(fStack.getAmount() - 1);
                fStack.writeToNBT(stackInHand.m_41783_().m_128469_("Fluid"));
            }
            return InteractionResultHolder.m_19090_((Object)stackInHand);
        }
        tag.m_128405_("Type", 0);
        return InteractionResultHolder.m_19090_((Object)stackInHand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        ItemStack itemstack = context.m_43722_();
        if (itemstack.m_41783_() == null || itemstack.m_41783_().m_128451_("Type") != 2) {
            return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        if (!(CampfireBlock.m_51321_((BlockState)blockstate) || CandleBlock.m_152845_((BlockState)blockstate) || CandleCakeBlock.m_152910_((BlockState)blockstate))) {
            BlockPos blockpos1;
            BlockEntity cb;
            if (((Boolean)ConfigRegistry.COMBUSTIBLES_BLOW_UP.get()).booleanValue() && (cb = level.m_7702_(blockpos)) != null) {
                IFluidHandler tank = (IFluidHandler)cb.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
                if (tank == null) {
                    return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
                }
                if (FuelTypeManager.getGeneratedSpeed(tank.getFluidInTank(0).getFluid()) != 0.0f) {
                    level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
                    level.m_254877_(null, null, null, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), 3.0f + (float)tank.getFluidInTank(0).getAmount() / 500.0f, true, Level.ExplosionInteraction.BLOCK);
                    CompoundTag tankCompound = itemstack.m_41783_().m_128469_("Fluid");
                    FluidStack fStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tankCompound);
                    if (FuelTypeManager.getGeneratedSpeed(fStack.getFluid()) != 0.0f && itemstack.m_41783_().m_128451_("Type") == 2) {
                        fStack.setAmount(fStack.getAmount() - 1);
                        fStack.writeToNBT(itemstack.m_41783_().m_128469_("Fluid"));
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            }
            if (BaseFireBlock.m_49255_((Level)level, (BlockPos)(blockpos1 = blockpos.m_121945_(context.m_43719_())), (Direction)context.m_8125_())) {
                CompoundTag tankCompound;
                FluidStack fStack;
                level.m_5594_(player, blockpos1, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                BlockState blockstate1 = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)blockpos1);
                level.m_7731_(blockpos1, blockstate1, 11);
                level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos1, itemstack);
                }
                if ((fStack = FluidStack.loadFluidStackFromNBT((CompoundTag)(tankCompound = itemstack.m_41783_().m_128469_("Fluid")))).getAmount() == 0) {
                    itemstack.m_41783_().m_128405_("Type", 1);
                    return InteractionResult.FAIL;
                }
                if (FuelTypeManager.getGeneratedSpeed(fStack.getFluid()) != 0.0f && itemstack.m_41783_().m_128451_("Type") == 2) {
                    fStack.setAmount(fStack.getAmount() - 1);
                    fStack.writeToNBT(itemstack.m_41783_().m_128469_("Fluid"));
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        level.m_5594_(player, blockpos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
        level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        level.m_142346_((Entity)player, GameEvent.f_157792_, blockpos);
        if (player != null) {
            context.m_43722_().m_41622_(1, (LivingEntity)player, p_41303_ -> p_41303_.m_21190_(context.m_43724_()));
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public boolean m_142522_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            CompoundTag tankCompound = stack.m_41783_().m_128469_("Fluid");
            FluidStack fStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tankCompound);
            return !fStack.isEmpty();
        }
        return false;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 0;
        }
        CompoundTag tankCompound = stack.m_41783_().m_128469_("Fluid");
        return Math.round(13.0f * Mth.m_14036_((float)((float)FluidStack.loadFluidStackFromNBT((CompoundTag)tankCompound).getAmount() / ((float)((Integer)ConfigRegistry.TOOL_CAPACITY.get()).intValue() + (float)(stack.getEnchantmentLevel((Enchantment)AllEnchantments.CAPACITY.get()) * (Integer)ConfigRegistry.TOOL_CAPACITY_ENCHANTMENT.get()))), (float)0.0f, (float)1.0f));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!ModList.get().isLoaded("dungeons_libraries")) {
            return new FluidHandlerItemStack(stack, (Integer)ConfigRegistry.TOOL_CAPACITY.get() + stack.getEnchantmentLevel((Enchantment)AllEnchantments.CAPACITY.get()) * (Integer)ConfigRegistry.TOOL_CAPACITY_ENCHANTMENT.get());
        }
        return new FluidHandlerItemStack(stack, ((Integer)ConfigRegistry.TOOL_CAPACITY.get()).intValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new LighterItemRenderer()));
    }
}

