/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.world.OilChunksSavedData;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PumpjackHoleBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation {
    BlockState state;
    SmartFluidTankBehaviour tank;
    public int headPos = 0;
    public int bearingPos = 0;
    public boolean started = false;
    public int oilAmount = 0;
    public int storedOilAmount = 0;
    byte tt = 0;
    public int pipeLength = 0;
    boolean valid = false;

    public PumpjackHoleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.state = state;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.tank.write(compound, false);
        compound.m_128405_("StoredOilAmount", this.storedOilAmount);
        compound.m_128405_("OilAmount", this.oilAmount);
        compound.m_128379_("Started", this.started);
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.valid) {
            return false;
        }
        Lang.builder().add(Components.translatable((String)"createdieselgenerators.goggle.problem_encountered")).style(ChatFormatting.GOLD).forGoggles(tooltip);
        Lang.builder().add(Components.translatable((String)"createdieselgenerators.goggle.pumpjack_invalid_pipes")).style(ChatFormatting.GRAY).forGoggles(tooltip);
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!this.valid || !this.started) {
            return false;
        }
        Lang.builder().add(Components.translatable((String)"createdieselgenerators.goggle.oil_amount")).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.number((double)this.oilAmount).add(Lang.translate((String)"generic.unit.buckets", (Object[])new Object[0])).style(ChatFormatting.GOLD).forGoggles(tooltip);
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.read(compound, false);
        this.storedOilAmount = compound.m_128451_("StoredOilAmount");
        this.oilAmount = compound.m_128451_("OilAmount");
        this.started = compound.m_128471_("Started");
    }

    public void handleUpdateTag(CompoundTag compound) {
        super.handleUpdateTag(compound);
        this.oilAmount = compound.m_128451_("OilAmount");
        this.started = compound.m_128471_("Started");
    }

    public void tick() {
        super.tick();
        this.tt = (byte)(this.tt + 1);
        if (this.tt >= 20) {
            int pipeLength = 0;
            this.tt = 0;
            boolean v = false;
            for (int i = 0; i < this.m_58899_().m_123342_() - this.f_58857_.m_141937_(); ++i) {
                ++pipeLength;
                BlockState bs = this.f_58857_.m_8055_(this.m_58899_().m_6625_(i + 1));
                if (bs.m_60734_() instanceof PipeBlock || bs.m_60734_() instanceof EncasedPipeBlock) {
                    if (((Boolean)bs.m_61143_((Property)BlockStateProperties.f_61366_)).booleanValue() && ((Boolean)bs.m_61143_((Property)BlockStateProperties.f_61367_)).booleanValue()) continue;
                    break;
                }
                if (bs.m_60734_() instanceof GlassFluidPipeBlock) {
                    if (bs.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y) continue;
                    break;
                }
                if (bs.m_204336_(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)new ResourceLocation("createdieselgenerators:pumpjack_pipe")))) continue;
                if (!bs.m_204336_(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)new ResourceLocation("createdieselgenerators:oil_deposit")))) break;
                v = true;
                break;
            }
            this.pipeLength = v ? pipeLength : 0;
            this.valid = v;
        }
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_((double)this.pipeLength);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        compound.m_128405_("OilAmount", this.oilAmount);
        compound.m_128379_("Started", this.started);
        return compound;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public void tickFluid(boolean isCrankLarge) {
        if (!this.f_58857_.f_46443_ && this.valid) {
            ChunkPos chunkPos = new ChunkPos(this.m_58899_());
            OilChunksSavedData sd = OilChunksSavedData.load((ServerLevel)this.f_58857_);
            int amount = sd.getChunkOilAmount(chunkPos);
            if (amount == -1) {
                amount = CreateDieselGenerators.getOilAmount((Holder<Biome>)this.f_58857_.m_204166_(new BlockPos(chunkPos.f_45578_ * 16, 64, chunkPos.f_45579_ * 16)), chunkPos.f_45578_, chunkPos.f_45579_, ((ServerLevel)this.f_58857_).m_7328_());
            }
            this.oilAmount = amount;
            this.started = true;
            if (amount == 0) {
                return;
            }
            if (this.storedOilAmount == 0) {
                sd.setChunkAmount(chunkPos, amount - 1);
                this.oilAmount = amount - 1;
                this.storedOilAmount = 1000;
            }
            int subtractedAmount = Mth.m_14045_((int)((int)(100.0f * Math.abs((float)this.headPos / (float)this.bearingPos)) * (isCrankLarge ? 2 : 1)), (int)0, (int)1000);
            this.storedOilAmount = this.storedOilAmount < subtractedAmount ? 0 : (int)((float)this.storedOilAmount - 100.0f / Math.abs((float)this.headPos / (float)this.bearingPos));
            List stackList = ForgeRegistries.FLUIDS.tags().getTag(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:pumpjack_output"))).stream().distinct().toList();
            if (stackList.isEmpty()) {
                return;
            }
            FluidStack oilStack = new FluidStack((Fluid)stackList.get(0), subtractedAmount);
            this.tank.getPrimaryHandler().fill(oilStack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap != ForgeCapabilities.FLUID_HANDLER) {
            return super.getCapability(cap, side);
        }
        if (side == Direction.NORTH && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
            return this.tank.getCapability().cast();
        }
        if (side == Direction.EAST && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
            return this.tank.getCapability().cast();
        }
        if (side == Direction.SOUTH && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
            return this.tank.getCapability().cast();
        }
        if (side == Direction.WEST && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

