/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jesz.createdieselgenerators.CreativeTab;
import com.jesz.createdieselgenerators.PartialModels;
import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.blocks.ct.SpriteShifts;
import com.jesz.createdieselgenerators.blocks.entity.BlockEntityRegistry;
import com.jesz.createdieselgenerators.compat.EveryCompatCompat;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.entity.EntityRegistry;
import com.jesz.createdieselgenerators.fluids.FluidRegistry;
import com.jesz.createdieselgenerators.items.ItemRegistry;
import com.jesz.createdieselgenerators.other.CDGPartialModel;
import com.jesz.createdieselgenerators.other.SpoutCanisterFilling;
import com.jesz.createdieselgenerators.ponder.PonderIndex;
import com.jesz.createdieselgenerators.recipes.RecipeRegistry;
import com.jesz.createdieselgenerators.sounds.SoundRegistry;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.behaviour.BlockSpoutingBehaviour;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.foundation.data.CreateRegistrate;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="createdieselgenerators")
public class CreateDieselGenerators {
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"createdieselgenerators");
    public static Map<String, String> lighterSkins = new HashMap<String, String>();

    public CreateDieselGenerators() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        ItemRegistry.register();
        BlockRegistry.register();
        FluidRegistry.register();
        BlockEntityRegistry.register();
        EntityRegistry.register();
        SoundRegistry.register(modEventBus);
        RecipeRegistry.register(modEventBus);
        CreativeTab.register(modEventBus);
        if (ModList.get().isLoaded("moonlight")) {
            EveryCompatCompat.init();
        }
        Mods.COMPUTERCRAFT.executeIfInstalled(() -> CCProxy::register);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateDieselGenerators.onClient(modEventBus, forgeEventBus));
        BlockSpoutingBehaviour.addCustomSpoutInteraction((ResourceLocation)new ResourceLocation("createdieselgenerators:canister_filling"), (BlockSpoutingBehaviour)new SpoutCanisterFilling());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigRegistry.SERVER_SPEC, "createdieselgenerators-server.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRATE.registerEventListeners(modEventBus);
    }

    public static void onClient(IEventBus modEventBus, IEventBus forgeEventBus) {
        PartialModels.init();
        SpriteShifts.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigRegistry.CLIENT_SPEC, "createdieselgenerators-client.toml");
        modEventBus.addListener(CreateDieselGenerators::clientInit);
        modEventBus.addListener(CreateDieselGenerators::onModelRegistry);
        modEventBus.addListener(CDGPartialModel::onModelBake);
    }

    public static void onModelRegistry(ModelEvent.RegisterAdditional event) {
        lighterSkins.clear();
        Minecraft.m_91087_().m_91098_().m_7187_().stream().toList().forEach(n -> {
            Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(n, "lighter_skins.json"));
            if (resource.isEmpty()) {
                return;
            }
            JsonParser parser = new JsonParser();
            try {
                JsonElement data = parser.parse((Reader)((Resource)resource.get()).m_215508_());
                data.getAsJsonArray().forEach(jsonElement -> lighterSkins.put(jsonElement.getAsJsonObject().getAsJsonPrimitive("name").getAsString(), jsonElement.getAsJsonObject().getAsJsonPrimitive("id").getAsString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        PartialModels.initSkins();
        CDGPartialModel.onModelRegistry(event);
    }

    public static void clientInit(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.ETHANOL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)FluidRegistry.ETHANOL.getSource(), (RenderType)RenderType.m_110466_());
        PonderIndex.register();
    }

    public static int getOilAmount(Holder<Biome> biome, int x, int z, long seed) {
        boolean isHighInOil;
        Random random = new Random(new Random(seed).nextLong() + (long)x * (long)z);
        int amount = Math.abs(random.nextInt());
        boolean bl = isHighInOil = biome == null || biome.m_203656_(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BIOMES, (ResourceLocation)new ResourceLocation("createdieselgenerators:oil_biomes")));
        if (biome != null && biome.m_203656_(AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BIOMES, (ResourceLocation)new ResourceLocation("createdieselgenerators:deny_oil_biomes")))) {
            return 0;
        }
        if (isHighInOil ? (double)random.nextFloat(0.0f, 100.0f) >= (Double)ConfigRegistry.HIGH_OIL_PERCENTAGE.get() : (double)(amount % 100) >= (Double)ConfigRegistry.OIL_PERCENTAGE.get()) {
            return 0;
        }
        if (((Boolean)ConfigRegistry.OIL_DEPOSITS_INFINITE.get()).booleanValue()) {
            return Integer.MAX_VALUE;
        }
        if (isHighInOil) {
            return (int)((double)Mth.m_14045_((int)(amount % 400000), (int)8000, (int)400000) * (Double)ConfigRegistry.HIGH_OIL_MULTIPLIER.get());
        }
        return (int)((double)Mth.m_14045_((int)(amount % 15000), (int)0, (int)12000) * (Double)ConfigRegistry.OIL_MULTIPLIER.get());
    }
}

