/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.sequencedpulsegenerator;

import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCGuiTextures;
import com.hlysine.create_connected.CCPackets;
import com.hlysine.create_connected.Lang;
import com.hlysine.create_connected.content.sequencedpulsegenerator.ConfigureSequencedPulseGeneratorPacket;
import com.hlysine.create_connected.content.sequencedpulsegenerator.SequencedPulseGeneratorBlockEntity;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.EndInstruction;
import com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.Instruction;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Components;
import java.util.Vector;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class SequencedPulseGeneratorScreen
extends AbstractSimiScreen {
    private final ItemStack renderedItem = CCBlocks.SEQUENCED_PULSE_GENERATOR.asStack();
    private final CCGuiTextures background = CCGuiTextures.SEQUENCER;
    private IconButton confirmButton;
    private final SequencedPulseGeneratorBlockEntity be;
    private final ListTag compareTag;
    private final Vector<Instruction> instructions;
    private Vector<Vector<ScrollInput>> inputs;

    public SequencedPulseGeneratorScreen(SequencedPulseGeneratorBlockEntity be) {
        super((Component)Lang.translateDirect("gui.sequenced_pulse_generator.title", new Object[0]));
        this.instructions = be.instructions;
        this.be = be;
        this.compareTag = Instruction.serializeAll(this.instructions);
    }

    protected void m_7856_() {
        int row;
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-20, 0);
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.inputs = new Vector(7);
        for (row = 0; row < this.inputs.capacity(); ++row) {
            this.inputs.add(new Vector(3));
        }
        for (row = 0; row < this.instructions.size(); ++row) {
            this.initInputsOfRow(row, x, y);
        }
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> ((SequencedPulseGeneratorScreen)this).m_7379_());
        this.m_142416_((GuiEventListener)this.confirmButton);
    }

    public void initInputsOfRow(int row, int backgroundX, int backgroundY) {
        int x = backgroundX + 30;
        int y = backgroundY + 20;
        int rowHeight = 22;
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        this.removeWidgets(rowInputs);
        rowInputs.clear();
        Instruction instruction = this.instructions.get(row);
        ScrollInput type = new SelectionScrollInput(x, y + rowHeight * row, 50, 18).forOptions(Instruction.getOptions()).calling(state -> this.instructionUpdated(row, (int)state)).setState(instruction.getOrdinal()).titled(Lang.translateDirect("gui.sequenced_pulse_generator.instruction", new Object[0]));
        ScrollInput value = new ScrollInput(x + 58, y + rowHeight * row, 28, 18).calling(state -> this.instructions.get(row).setValue((int)state));
        ScrollInput signal = new ScrollInput(x + 88, y + rowHeight * row, 28, 18).withRange(0, 16).setState(instruction.getSignal()).calling(state -> this.instructions.get(row).setSignal((int)state)).titled(Lang.translateDirect("gui.sequenced_pulse_generator.signal", new Object[0]));
        rowInputs.add(type);
        rowInputs.add(value);
        rowInputs.add(signal);
        this.addRenderableWidgets(rowInputs);
        this.updateParamsOfRow(row);
    }

    public void updateParamsOfRow(int row) {
        Instruction instruction = this.instructions.get(row);
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        boolean hasValue = instruction.parameter != null;
        boolean hasSignal = instruction.hasSignal;
        ScrollInput value = rowInputs.get(1);
        value.f_93623_ = value.f_93624_ = hasValue;
        if (hasValue) {
            value.withRange(instruction.parameter.minValue(), instruction.parameter.maxValue() + 1).titled(Lang.translateDirect(instruction.getParameterLangKey(), new Object[0])).withShiftStep(instruction.parameter.shiftStepValue()).setState(instruction.getValue()).onChanged();
            if (instruction.parameter.stepFunction() != null) {
                value.withStepFunction(instruction.parameter.stepFunction());
            } else {
                value.withStepFunction(value.standardStep());
            }
        }
        ScrollInput signal = rowInputs.get(2);
        signal.f_93623_ = signal.f_93624_ = hasSignal;
        if (hasSignal) {
            signal.setState(instruction.getSignal());
        }
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int yOffset;
        CCGuiTextures toDraw;
        int row;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        for (row = 0; row < 7; ++row) {
            toDraw = CCGuiTextures.SEQUENCER_EMPTY;
            yOffset = toDraw.height * row;
            toDraw.render(graphics, x, y + 16 + yOffset);
        }
        for (row = 0; row < 7; ++row) {
            toDraw = CCGuiTextures.SEQUENCER_EMPTY;
            yOffset = toDraw.height * row;
            if (row >= this.instructions.size()) {
                toDraw.render(graphics, x, y + 16 + yOffset);
                continue;
            }
            Instruction instruction = this.instructions.get(row);
            instruction.getBackground().render(graphics, x, y + 16 + yOffset);
            this.label(graphics, 36, yOffset - 1, (Component)Lang.translateDirect(instruction.getLangKey(), new Object[0]));
            if (instruction.parameter != null) {
                Function<Integer, String> formatter = instruction.parameter.formatter();
                String text = formatter == null ? String.valueOf(instruction.getValue()) : formatter.apply(instruction.getValue());
                int stringWidth = this.f_96547_.m_92895_(text);
                this.label(graphics, 90 + (12 - stringWidth / 2), yOffset - 1, (Component)Components.literal((String)text));
            }
            if (!instruction.hasSignal) continue;
            this.label(graphics, 127, yOffset - 1, (Component)Components.literal((String)String.valueOf(instruction.getSignal())));
        }
        graphics.m_280614_(this.f_96547_, this.f_96539_, x + (this.background.width - 8) / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, y + 4, 5841956, false);
        this.renderAdditional(graphics, mouseX, mouseY, partialTicks, x, y, this.background);
    }

    private void renderAdditional(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, int guiLeft, int guiTop, CCGuiTextures background) {
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(guiLeft + background.width + 6), (float)(guiTop + background.height - 56), 100.0f)).scale(5.0).render(graphics);
    }

    private void label(GuiGraphics graphics, int x, int y, Component text) {
        graphics.m_280430_(this.f_96547_, text, this.guiLeft + x, this.guiTop + 26 + y, 0xFFFFEE);
    }

    public void sendPacket() {
        ListTag serialized = Instruction.serializeAll(this.instructions);
        if (serialized.equals((Object)this.compareTag)) {
            return;
        }
        CCPackets.getChannel().sendToServer((Object)new ConfigureSequencedPulseGeneratorPacket(this.be.m_58899_(), serialized));
    }

    public void m_7861_() {
        this.sendPacket();
    }

    private void instructionUpdated(int index, int state) {
        Instruction newValue = Instruction.getByOrdinal(state);
        this.instructions.set(index, newValue);
        this.updateParamsOfRow(index);
        if (newValue.terminal) {
            for (int i = this.instructions.size() - 1; i > index; --i) {
                this.instructions.remove(i);
                Vector<ScrollInput> rowInputs = this.inputs.get(i);
                this.removeWidgets(rowInputs);
                rowInputs.clear();
            }
        } else if (index + 1 < 7 && index + 1 == this.instructions.size()) {
            this.instructions.add(new EndInstruction());
            this.initInputsOfRow(index + 1, this.guiLeft, this.guiTop);
        }
    }
}

