/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDumpButton;
import mekanism.client.gui.element.bar.GuiChemicalBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiSortingTab;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.ISupportsWarning;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.factory.TileEntityItemStackGasToItemStackFactory;
import mekanism.common.tile.factory.TileEntityMetallurgicInfuserFactory;
import mekanism.common.tile.factory.TileEntitySawingFactory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiFactory
extends GuiConfigurableTile<TileEntityFactory<?>, MekanismTileContainer<TileEntityFactory<?>>> {
    public GuiFactory(MekanismTileContainer<TileEntityFactory<?>> container, Inventory inv, Component title) {
        super(container, inv, title);
        if (((TileEntityFactory)this.tile).hasSecondaryResourceBar()) {
            this.f_97727_ += 11;
            this.f_97731_ = 85;
        } else if (this.tile instanceof TileEntitySawingFactory) {
            this.f_97727_ += 21;
            this.f_97731_ = 95;
        } else {
            this.f_97731_ = 75;
        }
        if (((TileEntityFactory)this.tile).tier == FactoryTier.ULTIMATE) {
            this.f_97726_ += 34;
            this.f_97730_ = 26;
        }
        this.f_97729_ = 4;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        int baseX;
        super.addGuiElements();
        this.addRenderableWidget(new GuiSortingTab(this, (TileEntityFactory)this.tile));
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityFactory)this.tile).getEnergyContainer(), this.f_97726_ - 12, 16, this.tile instanceof TileEntitySawingFactory ? 73 : 52)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, ((TileEntityFactory)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, 0));
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityFactory)this.tile).getEnergyContainer(), ((TileEntityFactory)this.tile)::getLastUsage));
        if (((TileEntityFactory)this.tile).hasSecondaryResourceBar()) {
            ISupportsWarning secondaryBar = null;
            TileEntityMekanism tileEntityMekanism = this.tile;
            if (tileEntityMekanism instanceof TileEntityMetallurgicInfuserFactory) {
                TileEntityMetallurgicInfuserFactory factory = (TileEntityMetallurgicInfuserFactory)tileEntityMekanism;
                secondaryBar = this.addRenderableWidget(new GuiChemicalBar(this, GuiChemicalBar.getProvider(factory.getInfusionTank(), ((TileEntityFactory)this.tile).getInfusionTanks(null)), 7, 76, ((TileEntityFactory)this.tile).tier == FactoryTier.ULTIMATE ? 172 : 138, 4, true));
                this.addRenderableWidget(new GuiDumpButton<TileEntityMetallurgicInfuserFactory>(this, factory, ((TileEntityFactory)this.tile).tier == FactoryTier.ULTIMATE ? 182 : 148, 76));
            } else {
                tileEntityMekanism = this.tile;
                if (tileEntityMekanism instanceof TileEntityItemStackGasToItemStackFactory) {
                    TileEntityItemStackGasToItemStackFactory factory = (TileEntityItemStackGasToItemStackFactory)tileEntityMekanism;
                    secondaryBar = this.addRenderableWidget(new GuiChemicalBar(this, GuiChemicalBar.getProvider(factory.getGasTank(), ((TileEntityFactory)this.tile).getGasTanks(null)), 7, 76, ((TileEntityFactory)this.tile).tier == FactoryTier.ULTIMATE ? 172 : 138, 4, true));
                    this.addRenderableWidget(new GuiDumpButton<TileEntityItemStackGasToItemStackFactory>(this, factory, ((TileEntityFactory)this.tile).tier == FactoryTier.ULTIMATE ? 182 : 148, 76));
                }
            }
            if (secondaryBar != null) {
                secondaryBar.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, ((TileEntityFactory)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, 0));
            }
        }
        int n = ((TileEntityFactory)this.tile).tier == FactoryTier.BASIC ? 55 : (((TileEntityFactory)this.tile).tier == FactoryTier.ADVANCED ? 35 : (baseX = ((TileEntityFactory)this.tile).tier == FactoryTier.ELITE ? 29 : 27));
        int baseXMult = ((TileEntityFactory)this.tile).tier == FactoryTier.BASIC ? 38 : (((TileEntityFactory)this.tile).tier == FactoryTier.ADVANCED ? 26 : 19);
        for (int i = 0; i < ((TileEntityFactory)this.tile).tier.processes; ++i) {
            int cacheIndex = i;
            this.addProgress(new GuiProgress(() -> ((TileEntityFactory)this.tile).getScaledProgress(1, cacheIndex), ProgressType.DOWN, (IGuiWrapper)this, 4 + baseX + i * baseXMult, 33)).warning(WarningTracker.WarningType.INPUT_DOESNT_PRODUCE_OUTPUT, ((TileEntityFactory)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT, cacheIndex));
        }
    }

    private GuiProgress addProgress(GuiProgress progressBar) {
        MekanismJEIRecipeType<MekanismRecipe> jeiType = switch (((TileEntityFactory)this.tile).getFactoryType()) {
            default -> throw new IncompatibleClassChangeError();
            case FactoryType.SMELTING -> MekanismJEIRecipeType.SMELTING;
            case FactoryType.ENRICHING -> MekanismJEIRecipeType.ENRICHING;
            case FactoryType.CRUSHING -> MekanismJEIRecipeType.CRUSHING;
            case FactoryType.COMPRESSING -> MekanismJEIRecipeType.COMPRESSING;
            case FactoryType.COMBINING -> MekanismJEIRecipeType.COMBINING;
            case FactoryType.PURIFYING -> MekanismJEIRecipeType.PURIFYING;
            case FactoryType.INJECTING -> MekanismJEIRecipeType.INJECTING;
            case FactoryType.INFUSING -> MekanismJEIRecipeType.METALLURGIC_INFUSING;
            case FactoryType.SAWING -> MekanismJEIRecipeType.SAWING;
        };
        return (GuiProgress)this.addRenderableWidget(progressBar.jeiCategories(new MekanismJEIRecipeType[]{jeiType}));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

