/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.foundation.utility.Lang;
import java.util.Collections;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class AllTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return AllTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return AllTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void init() {
        AllBlockTags.init();
        AllItemTags.init();
        AllFluidTags.init();
        AllEntityTags.init();
        AllRecipeSerializerTags.init();
    }

    public static enum AllBlockTags {
        BRITTLE,
        CASING,
        CONTRAPTION_INVENTORY_DENY,
        COPYCAT_ALLOW,
        COPYCAT_DENY,
        FAN_PROCESSING_CATALYSTS_BLASTING(NameSpace.MOD, "fan_processing_catalysts/blasting"),
        FAN_PROCESSING_CATALYSTS_HAUNTING(NameSpace.MOD, "fan_processing_catalysts/haunting"),
        FAN_PROCESSING_CATALYSTS_SMOKING(NameSpace.MOD, "fan_processing_catalysts/smoking"),
        FAN_PROCESSING_CATALYSTS_SPLASHING(NameSpace.MOD, "fan_processing_catalysts/splashing"),
        FAN_TRANSPARENT,
        GIRDABLE_TRACKS,
        MOVABLE_EMPTY_COLLIDER,
        NON_MOVABLE,
        ORE_OVERRIDE_STONE,
        PASSIVE_BOILER_HEATERS,
        SAFE_NBT,
        SEATS,
        TOOLBOXES,
        TRACKS,
        TREE_ATTACHMENTS,
        VALVE_HANDLES,
        WINDMILL_SAILS,
        WRENCH_PICKUP,
        ROOTS,
        CORALS,
        RELOCATION_NOT_SUPPORTED(NameSpace.FORGE),
        WG_STONE(NameSpace.FORGE),
        SLIMY_LOGS(NameSpace.TIC),
        NON_DOUBLE_DOOR(NameSpace.QUARK);

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.BLOCKS, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllItemTags {
        BLAZE_BURNER_FUEL_REGULAR(NameSpace.MOD, "blaze_burner_fuel/regular"),
        BLAZE_BURNER_FUEL_SPECIAL(NameSpace.MOD, "blaze_burner_fuel/special"),
        CASING,
        CONTRAPTION_CONTROLLED,
        CREATE_INGOTS,
        CRUSHED_RAW_MATERIALS,
        DEPLOYABLE_DRINK,
        MODDED_STRIPPED_LOGS,
        MODDED_STRIPPED_WOOD,
        PRESSURIZED_AIR_SOURCES,
        SANDPAPER,
        SEATS,
        SLEEPERS,
        TOOLBOXES,
        TRACKS,
        UPRIGHT_ON_BELT,
        VALVE_HANDLES,
        VANILLA_STRIPPED_LOGS,
        VANILLA_STRIPPED_WOOD,
        STRIPPED_LOGS(NameSpace.FORGE),
        STRIPPED_WOOD(NameSpace.FORGE),
        PLATES(NameSpace.FORGE),
        OBSIDIAN_DUST(NameSpace.FORGE, "dusts/obsidian"),
        WRENCH(NameSpace.FORGE, "tools/wrench"),
        ALLURITE(NameSpace.MOD, "stone_types/galosphere/allurite"),
        AMETHYST(NameSpace.MOD, "stone_types/galosphere/amethyst"),
        LUMIERE(NameSpace.MOD, "stone_types/galosphere/lumiere"),
        UA_CORAL(NameSpace.MOD, "upgrade_aquatic/coral"),
        CURIOS_HEAD(NameSpace.CURIOS, "head");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllFluidTags {
        BOTTOMLESS_ALLOW(NameSpace.MOD, "bottomless/allow"),
        BOTTOMLESS_DENY(NameSpace.MOD, "bottomless/deny"),
        FAN_PROCESSING_CATALYSTS_BLASTING(NameSpace.MOD, "fan_processing_catalysts/blasting"),
        FAN_PROCESSING_CATALYSTS_HAUNTING(NameSpace.MOD, "fan_processing_catalysts/haunting"),
        FAN_PROCESSING_CATALYSTS_SMOKING(NameSpace.MOD, "fan_processing_catalysts/smoking"),
        FAN_PROCESSING_CATALYSTS_SPLASHING(NameSpace.MOD, "fan_processing_catalysts/splashing"),
        HONEY(NameSpace.FORGE);

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private AllFluidTags() {
            this(NameSpace.MOD);
        }

        private AllFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllEntityTags {
        BLAZE_BURNER_CAPTURABLE,
        IGNORE_SEAT;

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private AllEntityTags() {
            this(NameSpace.MOD);
        }

        private AllEntityTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllEntityTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllEntityTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllEntityTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.ENTITY_TYPES, id) : TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(EntityType<?> type) {
            return type.m_204039_(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.m_6095_());
        }

        private static void init() {
        }
    }

    public static enum AllRecipeSerializerTags {
        AUTOMATION_IGNORE;

        public final TagKey<RecipeSerializer<?>> tag;
        public final boolean alwaysDatagen;

        private AllRecipeSerializerTags() {
            this(NameSpace.MOD);
        }

        private AllRecipeSerializerTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllRecipeSerializerTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllRecipeSerializerTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllRecipeSerializerTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId(this.name()) : path);
            this.tag = optional ? AllTags.optionalTag(ForgeRegistries.RECIPE_SERIALIZERS, id) : TagKey.m_203882_((ResourceKey)Registries.f_256764_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(RecipeSerializer<?> recipeSerializer) {
            return ((Holder)ForgeRegistries.RECIPE_SERIALIZERS.getHolder(recipeSerializer).orElseThrow()).m_203656_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("create", false, true),
        FORGE("forge"),
        TIC("tconstruct"),
        QUARK("quark"),
        GS("galosphere"),
        CURIOS("curios");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

