/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.library.load.PluginCallerTimer;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginCaller {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void callOnPlugins(String title, List<IModPlugin> plugins, Consumer<IModPlugin> func) {
        LOGGER.info("{}...", (Object)title);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (PluginCallerTimer timer = new PluginCallerTimer();){
            ArrayList<IModPlugin> erroredPlugins = new ArrayList<IModPlugin>();
            for (IModPlugin plugin : plugins) {
                try {
                    ResourceLocation pluginUid = plugin.getPluginUid();
                    timer.begin(title, pluginUid);
                    func.accept(plugin);
                    timer.end();
                }
                catch (LinkageError | RuntimeException e) {
                    LOGGER.error("Caught an error from mod plugin: {} {}", plugin.getClass(), (Object)plugin.getPluginUid(), (Object)e);
                    erroredPlugins.add(plugin);
                }
            }
            plugins.removeAll(erroredPlugins);
        }
        LOGGER.info("{} took {}", (Object)title, (Object)stopwatch);
    }
}

