/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.autocannon.AbstractAutocannonProjectile;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoType;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class AutocannonProjectileRenderer<T extends AbstractAutocannonProjectile>
extends EntityRenderer<T> {
    private static final ResourceLocation SHRAPNEL_LOCATION = CreateBigCannons.resource("textures/entity/shrapnel.png");
    private static final ResourceLocation COLOR_LOCATION = CreateBigCannons.resource("textures/entity/color.png");
    private static final RenderType SHRAPNEL = RenderType.m_110458_((ResourceLocation)SHRAPNEL_LOCATION);
    private static final RenderType COLOR = RenderType.m_110470_((ResourceLocation)COLOR_LOCATION);

    public AutocannonProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight) {
        if (((AbstractAutocannonProjectile)((Object)entity)).isTracer()) {
            Vec3 previous = new Vec3(((AbstractAutocannonProjectile)((Object)entity)).f_19790_, ((AbstractAutocannonProjectile)((Object)entity)).f_19791_, ((AbstractAutocannonProjectile)((Object)entity)).f_19792_);
            Vec3 diff = entity.m_20182_().m_82546_(previous);
            double dlSqr = diff.m_82556_();
            boolean isFastButNotTeleported = 1.0E-4 <= dlSqr && dlSqr <= entity.m_20184_().m_82556_() * 4.0;
            double diffLength = isFastButNotTeleported ? diff.m_82553_() : 0.0;
            double displacement = ((AbstractAutocannonProjectile)((Object)entity)).getTotalDisplacement() - diffLength * (double)(1.0f - partialTicks);
            float length = (float)Math.min(diffLength, displacement);
            Vec3 vel = ((AbstractCannonProjectile)((Object)entity)).getOrientation();
            if (vel.m_82556_() < 1.0E-4) {
                vel = new Vec3(0.0, -1.0, 0.0);
            }
            poseStack.m_85836_();
            if (vel.m_165925_() > 1.0E-4 && Math.abs(vel.f_82480_) > 0.01) {
                Vec3 horizontal = new Vec3(vel.f_82479_, 0.0, vel.f_82481_).m_82541_();
                poseStack.m_252931_(CBCUtils.mat4x4fFacing(vel.m_82541_().m_82548_(), horizontal));
                poseStack.m_252931_(CBCUtils.mat4x4fFacing(horizontal, new Vec3(0.0, 0.0, -1.0)));
            } else {
                poseStack.m_252931_(CBCUtils.mat4x4fFacing(vel.m_82541_(), new Vec3(0.0, 0.0, -1.0)));
            }
            PoseStack.Pose lastPose = poseStack.m_85850_();
            Matrix4f pose = lastPose.m_252922_();
            Matrix3f normal = lastPose.m_252943_();
            VertexConsumer vcons = buffers.m_6299_(COLOR);
            float thickness = ((AbstractAutocannonProjectile)((Object)entity)).getAutocannonRoundType() == AutocannonAmmoType.MACHINE_GUN ? 0.03125f : 0.0625f;
            AutocannonProjectileRenderer.renderBox(vcons, pose, 255, 216, 0, length, thickness);
            AutocannonProjectileRenderer.renderBoxInverted(vcons, pose, 255, 80, 0, length, thickness * 1.5f);
            poseStack.m_85849_();
        } else {
            poseStack.m_85836_();
            poseStack.m_252781_(this.f_114476_.m_253208_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            float scale = ((AbstractAutocannonProjectile)((Object)entity)).getAutocannonRoundType() == AutocannonAmmoType.MACHINE_GUN ? 0.5f : 1.0f;
            poseStack.m_85841_(scale, scale, scale);
            PoseStack.Pose lastPose = poseStack.m_85850_();
            Matrix4f pose = lastPose.m_252922_();
            Matrix3f normal = lastPose.m_252943_();
            VertexConsumer builder = buffers.m_6299_(SHRAPNEL);
            AutocannonProjectileRenderer.vertexShrapnel(builder, pose, normal, packedLight, -0.5f, -0.5f, 0, 1);
            AutocannonProjectileRenderer.vertexShrapnel(builder, pose, normal, packedLight, 0.5f, -0.5f, 1, 1);
            AutocannonProjectileRenderer.vertexShrapnel(builder, pose, normal, packedLight, 0.5f, 0.5f, 1, 0);
            AutocannonProjectileRenderer.vertexShrapnel(builder, pose, normal, packedLight, -0.5f, 0.5f, 0, 0);
            poseStack.m_85849_();
        }
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffers, packedLight);
    }

    public boolean shouldRender(T entity, Frustum frustrum, double x, double y, double z) {
        return ((AbstractAutocannonProjectile)((Object)entity)).isTracer();
    }

    private static void renderBox(VertexConsumer builder, Matrix4f pose, int r, int g, int b, float length, float thickness) {
        float x1 = -thickness;
        float y1 = -thickness;
        float z1 = -thickness - length;
        float x2 = thickness;
        float y2 = thickness;
        float z2 = thickness;
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z1);
    }

    private static void renderBoxInverted(VertexConsumer builder, Matrix4f pose, int r, int g, int b, float length, float thickness) {
        float x1 = -thickness;
        float y1 = -thickness;
        float z1 = -thickness - length;
        float x2 = thickness;
        float y2 = thickness;
        float z2 = thickness;
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y1, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z1);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x2, y2, z2);
        AutocannonProjectileRenderer.vertex(builder, pose, r, g, b, x1, y2, z2);
    }

    private static void vertex(VertexConsumer builder, Matrix4f pose, int r, int g, int b, float x, float y, float z) {
        builder.m_252986_(pose, x, y, z).m_6122_(r, g, b, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertexShrapnel(VertexConsumer builder, Matrix4f pose, Matrix3f normal, int packedLight, float x, float y, int u, int v) {
        builder.m_252986_(pose, x, y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(T entity) {
        return null;
    }
}

