/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_hit_effects;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.tag_utils.TypeAndTagDataHolder;
import rbasamoyai.createbigcannons.block_hit_effects.BlockTransformation;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class BlockImpactTransformationHandler {
    private static final TypeAndTagDataHolder<Block, BlockTransformation> TRANSFORMS = new TypeAndTagDataHolder(CBCRegistryUtils.getBlockRegistry());

    public static void loadTags() {
        TRANSFORMS.loadTags();
    }

    public static BlockState transformBlock(BlockState blockState) {
        BlockTransformation transform = TRANSFORMS.getData(blockState.m_60734_());
        return transform == null ? blockState : transform.transformBlock(blockState);
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        ReloadListener() {
            super(GSON, "block_impact_transforms");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
            TRANSFORMS.cleanUp();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    ResourceLocation loc = entry.getKey();
                    if (loc.m_135815_().startsWith("tags/")) {
                        ResourceLocation pruned = CBCUtils.location(loc.m_135827_(), loc.m_135815_().substring(5));
                        TagKey tag = TagKey.m_203882_(CBCRegistryUtils.getBlockRegistryKey(), (ResourceLocation)pruned);
                        TRANSFORMS.addTagData((TagKey<Block>)tag, BlockTransformation.fromJson(el.getAsJsonObject()));
                        continue;
                    }
                    Block block = CBCRegistryUtils.getOptionalBlock(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                    TRANSFORMS.addData(block, BlockTransformation.fromJson(el.getAsJsonObject()));
                }
                catch (Exception e) {
                    CreateBigCannons.LOGGER.warn("Exception loading block impact transforms: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

