/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.item;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import com.tom.morewires.WireTypeDefinition;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MultiCoilItem
extends IEBaseItem
implements IWireCoil {
    private static final String MULTI_WIRE_ID = "MultiWireId";
    private final MultiWireInfo def;

    public MultiCoilItem(MultiWireInfo def) {
        super(new Item.Properties());
        this.def = def;
    }

    public WireType getWireType(ItemStack stack) {
        String id = null;
        if (stack.m_41782_()) {
            id = stack.m_41783_().m_128461_(MULTI_WIRE_ID);
        }
        return this.def.getWireTypeById(id);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if (WirecoilUtils.hasWireLink((ItemStack)stack)) {
            WireLink link = WireLink.readFromItem((ItemStack)stack);
            list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link.cp.getX(), link.cp.getY(), link.cp.getZ(), link.dimension}));
            list.add((Component)Component.m_237110_((String)"tooltip.more_immersive_wires.network_type", (Object[])new Object[]{Component.m_237115_((String)("tooltip.more_immersive_wires.network_type." + stack.m_41783_().m_128461_(MULTI_WIRE_ID)))}));
        }
        this.def.appendHoverTextCoil(stack, world, list, flag);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        CompoundTag tag;
        IImmersiveConnectable ic;
        BlockEntity tileEntity = ctx.m_43725_().m_7702_(ctx.m_8083_());
        if (tileEntity instanceof IImmersiveConnectable && (ic = (IImmersiveConnectable)tileEntity).canConnect()) {
            IImmersiveConnectable iicHere;
            Direction side = ctx.m_43719_();
            BlockPos pos = ctx.m_8083_();
            float hitX = (float)ctx.m_43720_().f_82479_;
            float hitY = (float)ctx.m_43720_().f_82480_;
            float hitZ = (float)ctx.m_43720_().f_82481_;
            TargetingInfo targetHere = new TargetingInfo(side, hitX - (float)pos.m_123341_(), hitY - (float)pos.m_123342_(), hitZ - (float)pos.m_123343_());
            BlockPos masterPos = ic.getConnectionMaster(this.def.getDefWire(), targetHere);
            BlockPos masterOffsetHere = pos.m_121996_((Vec3i)masterPos);
            tileEntity = ctx.m_43725_().m_7702_(masterPos);
            if (!(tileEntity instanceof IImmersiveConnectable) || !(iicHere = (IImmersiveConnectable)tileEntity).canConnect()) {
                return InteractionResult.PASS;
            }
            ConnectionPoint cpHere = iicHere.getTargetedPoint(targetHere, (Vec3i)masterOffsetHere);
            String id = this.def.getTypeId(ctx.m_43725_(), new MultiWireInfo.ConnectorTypeInfo(ctx.m_43725_().m_8055_(cpHere.position()).m_60734_(), cpHere.index()));
            CompoundTag tag2 = ctx.m_43722_().m_41784_();
            if (tag2.m_128441_(MULTI_WIRE_ID) && WirecoilUtils.hasWireLink((ItemStack)ctx.m_43722_())) {
                String c = tag2.m_128461_(MULTI_WIRE_ID);
                if (!c.equals(id)) {
                    if (!ctx.m_43725_().f_46443_) {
                        ctx.m_43723_().m_5661_((Component)Component.m_237115_((String)"chat.immersiveengineering.warning.wrongCable"), true);
                    }
                    return InteractionResult.FAIL;
                }
            } else {
                tag2.m_128359_(MULTI_WIRE_ID, id);
            }
        }
        InteractionResult ir = WirecoilUtils.doCoilUse((IWireCoil)this, (Player)ctx.m_43723_(), (Level)ctx.m_43725_(), (BlockPos)ctx.m_8083_(), (InteractionHand)ctx.m_43724_(), (Direction)ctx.m_43719_(), (float)((float)ctx.m_43720_().f_82479_), (float)((float)ctx.m_43720_().f_82480_), (float)((float)ctx.m_43720_().f_82481_));
        if (!WirecoilUtils.hasWireLink((ItemStack)ctx.m_43722_()) && (tag = ctx.m_43722_().m_41783_()) != null) {
            tag.m_128473_(MULTI_WIRE_ID);
            if (tag.m_128456_()) {
                ctx.m_43722_().m_41751_(null);
            }
        }
        return ir;
    }

    public static interface MultiWireInfo
    extends WireTypeDefinition.WireInfo {
        public WireType getWireTypeById(String var1);

        public WireType getDefWire();

        public String getTypeId(Level var1, ConnectorTypeInfo var2);

        public void appendHoverTextCoil(ItemStack var1, Level var2, List<Component> var3, TooltipFlag var4);

        public record ConnectorTypeInfo(Block block, int ind) {
        }
    }
}

