/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IIngredientWithSizeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;

public class IngredientWithSizeSerializer
implements IIngredientWithSizeSerializer {
    public static final IngredientWithSizeSerializer INSTANCE = new IngredientWithSizeSerializer();
    private static final String COUNT_KEY = "count";
    private static final String BASE_KEY = "base_ingredient";

    @Override
    @Nonnull
    public IngredientWithSize parse(@Nonnull FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        return new IngredientWithSize(base, count);
    }

    @Override
    public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull IngredientWithSize ingredient) {
        buffer.writeInt(ingredient.getCount());
        CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)ingredient.getBaseIngredient());
    }

    @Override
    @Nonnull
    public IngredientWithSize parse(@Nonnull JsonElement json) {
        if (json.isJsonObject() && json.getAsJsonObject().has(BASE_KEY)) {
            int count = GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)COUNT_KEY, (int)1);
            JsonElement baseJson = json.getAsJsonObject().get(BASE_KEY);
            Ingredient base = Ingredient.m_43917_((JsonElement)baseJson);
            return new IngredientWithSize(base, count);
        }
        Ingredient base = Ingredient.m_43917_((JsonElement)json);
        return new IngredientWithSize(base, 1);
    }

    @Override
    public JsonElement write(@Nonnull IngredientWithSize ingredient) {
        if (ingredient.getCount() == 1) {
            return ingredient.getBaseIngredient().m_43942_();
        }
        JsonObject json = new JsonObject();
        json.addProperty(COUNT_KEY, (Number)ingredient.getCount());
        json.add(BASE_KEY, ingredient.getBaseIngredient().m_43942_());
        return json;
    }
}

