/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.heatpump;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.newage.NewAgeBlockEntityTypes;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.content.heat.heatpipe.HeatPipeBlock;
import org.antarcticgardens.newage.content.heat.heatpump.HeatPumpBlockEntity;
import org.jetbrains.annotations.Nullable;

public class HeatPumpBlock
extends Block
implements EntityBlock,
IWrenchable {
    public static BooleanProperty UP = BlockStateProperties.f_61366_;
    public static BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static DirectionProperty FACING = BlockStateProperties.f_61372_;

    public HeatPumpBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction dir = context.m_43719_();
        if (!context.m_7078_()) {
            dir = dir.m_122424_();
        }
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)dir);
        return HeatPipeBlock.updateState(state, (LevelAccessor)world, pos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return HeatPipeBlock.updateState(state, world, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
        level.m_186460_(pos, (Block)this, 1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83048_((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue() || facing == Direction.UP) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue() || facing == Direction.DOWN) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue() || facing == Direction.NORTH) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue() || facing == Direction.EAST) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue() || facing == Direction.SOUTH) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue() || facing == Direction.WEST) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return NewAgeBlockEntityTypes.HEAT_PUMP.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        int on = HeatPipeBlock.massPipe++;
        if (HeatPipeBlock.massPipe >= 20) {
            HeatPipeBlock.massPipe = 0;
        }
        return (world, blockPos, blockState, sel) -> {
            HeatBlockEntity hbe;
            HeatPumpBlockEntity self;
            if ((world.m_46467_() + (long)on) % 20L != 0L || !(sel instanceof HeatPumpBlockEntity) || (self = (HeatPumpBlockEntity)sel).m_58904_() == null) {
                return;
            }
            self.lastPump = 0.0f;
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            BlockEntity entity = world.m_7702_(blockPos.m_121945_(facing));
            if (entity instanceof HeatBlockEntity && (hbe = (HeatBlockEntity)entity).canAdd(facing)) {
                float ht = self.heat;
                hbe.addHeat(ht);
                self.lastPump += ht;
                self.heat -= ht;
                if (self.heat > 0.0f) {
                    self.heat = Math.max(0.0f, self.heat - 4.0f);
                }
                self.m_6596_();
            }
            HeatBlockEntity.handleOverheat(self);
            HeatBlockEntity.trySync(self);
        };
    }
}

