/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.mrjulsen.trafficcraft.recipe.IDamageableCraftingItem;
import de.mrjulsen.trafficcraft.registry.ModItems;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class DamageableItemRecipe
extends ShapelessRecipe {
    public DamageableItemRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(id, group, category, result, ingredients);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.DAMAGEABLE_ITEM_RECIPE.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList defaultedList = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < defaultedList.size(); ++i) {
            ItemStack stack = container.m_8020_(i);
            Item item = stack.m_41720_();
            if (item instanceof IDamageableCraftingItem) {
                int newDamage = stack.m_41773_() + 1;
                if (newDamage >= stack.m_41776_()) continue;
                stack = stack.m_41777_();
                stack.m_41721_(newDamage);
                defaultedList.set(i, (Object)stack);
                continue;
            }
            if (!item.m_41470_()) continue;
            defaultedList.set(i, (Object)new ItemStack((ItemLike)item.m_41469_()));
        }
        return defaultedList;
    }

    public static class Serializer
    implements RecipeSerializer<DamageableItemRecipe> {
        public DamageableItemRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> nonNullList = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonNullList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonNullList.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new DamageableItemRecipe(recipeId, string, craftingBookCategory, itemStack, nonNullList);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray ingredientArray) {
            NonNullList nonNullList = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)ingredientArray.get(i), (boolean)false);
                if (ingredient.m_43947_()) continue;
                nonNullList.add((Object)ingredient);
            }
            return nonNullList;
        }

        public DamageableItemRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String string = buffer.m_130277_();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int i = buffer.m_130242_();
            NonNullList nonNullList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonNullList.size(); ++j) {
                nonNullList.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemStack = buffer.m_130267_();
            return new DamageableItemRecipe(recipeId, string, craftingBookCategory, itemStack, (NonNullList<Ingredient>)nonNullList);
        }

        public void toNetwork(FriendlyByteBuf buffer, DamageableItemRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_(null));
        }
    }
}

