/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.ScheduledTask;
import de.mrjulsen.trafficcraft.block.AsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import dev.architectury.networking.NetworkManager;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public class RoadBuilderBuildRoadPacket
implements IPacketBase<RoadBuilderBuildRoadPacket> {
    private Location pos1;
    private Location pos2;
    private byte roadWidth;
    private boolean replaceBlocks;
    private RoadType roadType;

    public RoadBuilderBuildRoadPacket() {
    }

    public RoadBuilderBuildRoadPacket(Location pos1, Location pos2, byte roadWidth, boolean replaceBlocks, RoadType roadType) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.roadWidth = roadWidth;
        this.replaceBlocks = replaceBlocks;
        this.roadType = roadType;
    }

    public void encode(RoadBuilderBuildRoadPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130079_(packet.pos1.toNbt());
        buffer.m_130079_(packet.pos2.toNbt());
        buffer.writeByte((int)packet.roadWidth);
        buffer.writeBoolean(packet.replaceBlocks);
        buffer.m_130068_((Enum)packet.roadType);
    }

    public RoadBuilderBuildRoadPacket decode(FriendlyByteBuf buffer) {
        Location pos1 = Location.fromNbt((CompoundTag)buffer.m_130260_());
        Location pos2 = Location.fromNbt((CompoundTag)buffer.m_130260_());
        byte roadWidth = buffer.readByte();
        boolean replaceBlocks = buffer.readBoolean();
        RoadType roadType = (RoadType)buffer.m_130066_(RoadType.class);
        return new RoadBuilderBuildRoadPacket(pos1, pos2, roadWidth, replaceBlocks, roadType);
    }

    public void handle(RoadBuilderBuildRoadPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            Level level = sender.m_9236_();
            ItemStack item = null;
            InteractionHand hand = null;
            if (sender.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof RoadConstructionTool) {
                item = sender.m_21120_(InteractionHand.MAIN_HAND);
                hand = InteractionHand.MAIN_HAND;
            } else if (sender.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof RoadConstructionTool) {
                item = sender.m_21120_(InteractionHand.OFF_HAND);
                hand = InteractionHand.OFF_HAND;
            } else {
                return;
            }
            RoadConstructionTool.RoadBuildingData buildingData = RoadConstructionTool.prepareRoadBuilding(level, (Player)sender, hand, item, packet.pos1.getLocationVec3(), packet.pos2.getLocationVec3(), packet.roadWidth, packet.replaceBlocks, packet.roadType);
            ScheduledTask.create((Object)buildingData, (Level)level, (int)4, (int)buildingData.blocks.size(), packet::run);
        });
    }

    private boolean run(RoadConstructionTool.RoadBuildingData data, ScheduledTask.ScheduledTaskContext context) {
        boolean[] canContinue = new boolean[]{true};
        for (Map.Entry<BlockPos, Integer> block : data.blocks.get(context.iteration()).entrySet()) {
            if (!canContinue[0] || !data.player.m_6084_()) {
                return false;
            }
            if (!RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) && data.player.m_150109_().m_18947_(data.roadType.getSlope().m_5456_()) <= 0 && data.player.m_150109_().m_18947_(data.roadType.getBlock().m_5456_()) <= 0) {
                return false;
            }
            if (context.level().m_8055_(block.getKey()).m_60734_().m_155943_() == -1.0f) continue;
            if (block.getValue() > 0 && block.getValue() <= 7 && (RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) || data.player.m_150109_().m_18947_(data.roadType.getSlope().m_5456_()) > 0)) {
                Optional<ItemStack> stack;
                int countLeft;
                context.level().m_46961_(block.getKey(), !RoadBuilderBuildRoadPacket.isPlayerCreative(data.player));
                int layers = Math.min(block.getValue(), RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) ? Integer.MAX_VALUE : data.player.m_150109_().m_18947_(data.roadType.getSlope().m_5456_()));
                context.level().m_46597_(block.getKey(), (BlockState)data.roadType.getSlope().m_49966_().m_61124_((Property)AsphaltSlope.LAYERS, (Comparable)Integer.valueOf(layers)));
                if (RoadBuilderBuildRoadPacket.isPlayerCreative(data.player)) continue;
                for (countLeft = layers; canContinue[0] && countLeft > 0 && (stack = data.player.m_150109_().f_35974_.stream().filter(x -> x.m_150930_(data.roadType.getSlope().m_5456_())).findFirst()).isPresent(); countLeft -= Math.min(countLeft, stack.get().m_41613_())) {
                    int removeCount = countLeft;
                    stack.get().m_41774_(removeCount);
                    data.item.m_41622_(1, (LivingEntity)data.player, player -> {
                        player.m_21166_(data.hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                        canContinue[0] = false;
                    });
                }
                if (countLeft <= 0) continue;
                canContinue[0] = false;
                continue;
            }
            if (block.getValue() <= 7 || !RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) && data.player.m_150109_().m_18947_(data.roadType.getBlock().m_5456_()) <= 0) continue;
            context.level().m_46961_(block.getKey(), !RoadBuilderBuildRoadPacket.isPlayerCreative(data.player));
            context.level().m_46597_(block.getKey(), data.roadType.getBlock().m_49966_());
            if (RoadBuilderBuildRoadPacket.isPlayerCreative(data.player)) continue;
            Optional<ItemStack> stack = data.player.m_150109_().f_35974_.stream().filter(x -> x.m_150930_(data.roadType.getBlock().m_5456_())).findFirst();
            if (stack.isPresent()) {
                stack.get().m_41774_(1);
            } else {
                canContinue[0] = false;
            }
            data.item.m_41622_(1, (LivingEntity)data.player, player -> {
                player.m_21166_(data.hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                canContinue[0] = false;
            });
        }
        if (context.iteration() >= data.blocks.size() - 1) {
            if (context.level().m_46472_().m_135782_().equals((Object)BuiltinDimensionTypes.f_223539_.m_135782_())) {
                DLUtils.giveAdvancement((ServerPlayer)((ServerPlayer)data.player), (String)"trafficcraft", (String)"highway_to_hell", (String)"req");
            } else if (context.level().m_46472_().m_135782_().equals((Object)BuiltinDimensionTypes.f_223540_.m_135782_())) {
                DLUtils.giveAdvancement((ServerPlayer)((ServerPlayer)data.player), (String)"trafficcraft", (String)"final_destination", (String)"req");
            }
        }
        return canContinue[0];
    }

    private static boolean isPlayerCreative(Player pPlayer) {
        return pPlayer.m_7500_() || pPlayer.m_5833_();
    }
}

