/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.data;

import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureData;
import dev.architectury.utils.GameInstance;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.storage.LevelResource;

public class TrafficSignTextureManager {
    public static final String FILE_EXTENSION = "nbt";
    public static final String PATH = "data/trafficcraft_signs";

    public static LevelResource getResource(String filename) {
        return new LevelResource(String.format("%s/%s.%s", PATH, filename, FILE_EXTENSION));
    }

    public static TrafficSignTextureData load(String id) {
        if (id.startsWith("builtIn")) {
            NamedTrafficSignTextureReference.BuildInTrafficSignCodec codec = NamedTrafficSignTextureReference.BuildInTrafficSignCodec.decode(id);
            return new TrafficSignTextureData(codec.shape(), new byte[0], codec.width(), codec.height(), System.currentTimeMillis(), new UUID(0L, 0L));
        }
        File file = new File(GameInstance.getServer().m_129843_(TrafficSignTextureManager.getResource(id.toString())).toString());
        if (file.exists()) {
            try {
                return TrafficSignTextureData.deserializeNbt(NbtIo.m_128937_((File)file));
            }
            catch (IOException e) {
                TrafficCraft.LOGGER.error("The traffic sign texture with id " + id + " could not be loaded.", (Throwable)e);
            }
        } else {
            TrafficCraft.LOGGER.error("A traffic sign texture with id " + id + " does not exist.");
        }
        return TrafficSignTextureData.empty();
    }
}

