/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.data;

import de.mrjulsen.mcdragonlib.core.IIterableEnum;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.trafficcraft.block.data.IItemIcon;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import java.util.Arrays;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public enum TrafficLightTrigger implements StringRepresentable,
ITranslatableEnum,
IItemIcon,
IIterableEnum<TrafficLightTrigger>
{
    NONE("none", 0, (ItemLike)Blocks.f_50375_),
    ON_REQUEST("on_request", 1, (ItemLike)ModBlocks.TRAFFIC_LIGHT_REQUEST_BUTTON.get()),
    REDSTONE("redstone", 2, (ItemLike)Items.f_42451_);

    private String trigger;
    private byte index;
    private ItemLike icon;

    private TrafficLightTrigger(String shape, int index, ItemLike icon) {
        this.trigger = shape;
        this.index = (byte)index;
        this.icon = icon;
    }

    @Override
    public ItemLike getItemIcon() {
        return this.icon;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public byte getIndex() {
        return this.index;
    }

    public String getTranslationKey() {
        return String.format("gui.trafficcraft.trafficlight.trigger.%s", this.trigger);
    }

    public static TrafficLightTrigger getTriggerByIndex(byte index) {
        return Arrays.stream(TrafficLightTrigger.values()).filter(x -> x.getIndex() == index).findFirst().orElse(NONE);
    }

    public String m_7912_() {
        return this.trigger;
    }

    public String getEnumName() {
        return "trafficlighttrigger";
    }

    public String getEnumValueName() {
        return this.getTrigger();
    }

    public TrafficLightTrigger[] getValues() {
        return TrafficLightTrigger.values();
    }
}

