/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import de.mrjulsen.trafficcraft.block.entity.StreetLampBlockEntity;
import de.mrjulsen.trafficcraft.item.WrenchItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StreetLampBaseBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
ITrafficPostLike {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE_COMMON = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0);
    public static final VoxelShape SHAPE_PART_NORTH = Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)11.0, (double)25.0);
    public static final VoxelShape SHAPE_PART_SOUTH = Block.m_49796_((double)6.0, (double)4.0, (double)-9.0, (double)10.0, (double)11.0, (double)10.0);
    public static final VoxelShape SHAPE_PART_EAST = Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)25.0, (double)11.0, (double)10.0);
    public static final VoxelShape SHAPE_PART_WEST = Block.m_49796_((double)-9.0, (double)4.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0);
    public static final VoxelShape SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_PART_NORTH);
    public static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_PART_SOUTH);
    public static final VoxelShape SHAPE_EAST = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_PART_EAST);
    public static final VoxelShape SHAPE_WEST = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_PART_WEST);
    public static final VoxelShape SHAPE_SMALL_PART_NORTH = Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)17.0);
    public static final VoxelShape SHAPE_SMALL_PART_SOUTH = Block.m_49796_((double)6.0, (double)11.0, (double)-1.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_SMALL_PART_EAST = Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)17.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_SMALL_PART_WEST = Block.m_49796_((double)-1.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_SMALL_SOUTH = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_SMALL_PART_NORTH);
    public static final VoxelShape SHAPE_SMALL_NORTH = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_SMALL_PART_SOUTH);
    public static final VoxelShape SHAPE_SMALL_EAST = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_SMALL_PART_EAST);
    public static final VoxelShape SHAPE_SMALL_WEST = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_SMALL_PART_WEST);
    private LampType lampType;

    public StreetLampBaseBlock(LampType type) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(2.0f).m_60999_().m_60918_(SoundType.f_56743_).m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0));
        this.lampType = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE_COMMON;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (this.lampType == LampType.SMALL || this.lampType == LampType.SMALL_DOUBLE) {
            switch ((Direction)pState.m_61143_((Property)FACING)) {
                case NORTH: {
                    return this.lampType == LampType.SMALL ? SHAPE_SMALL_NORTH : Shapes.m_83110_((VoxelShape)SHAPE_SMALL_NORTH, (VoxelShape)SHAPE_SMALL_SOUTH);
                }
                case SOUTH: {
                    return this.lampType == LampType.SMALL ? SHAPE_SMALL_SOUTH : Shapes.m_83110_((VoxelShape)SHAPE_SMALL_NORTH, (VoxelShape)SHAPE_SMALL_SOUTH);
                }
                case EAST: {
                    return this.lampType == LampType.SMALL ? SHAPE_SMALL_EAST : Shapes.m_83110_((VoxelShape)SHAPE_SMALL_EAST, (VoxelShape)SHAPE_SMALL_WEST);
                }
                case WEST: {
                    return this.lampType == LampType.SMALL ? SHAPE_SMALL_WEST : Shapes.m_83110_((VoxelShape)SHAPE_SMALL_EAST, (VoxelShape)SHAPE_SMALL_WEST);
                }
            }
            return SHAPE_COMMON;
        }
        if (this.lampType == LampType.NORMAL || this.lampType == LampType.DOUBLE) {
            switch ((Direction)pState.m_61143_((Property)FACING)) {
                case NORTH: {
                    return this.lampType == LampType.NORMAL ? SHAPE_NORTH : Shapes.m_83110_((VoxelShape)SHAPE_NORTH, (VoxelShape)SHAPE_SOUTH);
                }
                case SOUTH: {
                    return this.lampType == LampType.NORMAL ? SHAPE_SOUTH : Shapes.m_83110_((VoxelShape)SHAPE_NORTH, (VoxelShape)SHAPE_SOUTH);
                }
                case EAST: {
                    return this.lampType == LampType.NORMAL ? SHAPE_EAST : Shapes.m_83110_((VoxelShape)SHAPE_EAST, (VoxelShape)SHAPE_WEST);
                }
                case WEST: {
                    return this.lampType == LampType.NORMAL ? SHAPE_WEST : Shapes.m_83110_((VoxelShape)SHAPE_EAST, (VoxelShape)SHAPE_WEST);
                }
            }
            return SHAPE_COMMON;
        }
        return SHAPE_COMMON;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack stack = pPlayer.m_150109_().m_36056_();
        Item item = stack.m_41720_();
        if (item instanceof WrenchItem) {
            if (!pLevel.f_46443_) {
                StreetLampBlockEntity blockEntity;
                BlockEntity blockEntity2 = pLevel.m_7702_(pPos);
                if (blockEntity2 instanceof StreetLampBlockEntity && (blockEntity = (StreetLampBlockEntity)blockEntity2).getOnTime() != blockEntity.getOffTime()) {
                    if (!pLevel.f_46443_) {
                        pPlayer.m_5661_((Component)TextUtils.translate((String)"block.trafficcraft.street_lamp.use.error_scheduled"), true);
                        return InteractionResult.FAIL;
                    }
                } else {
                    pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf((Boolean)pState.m_61143_((Property)LIT) == false)));
                }
            } else {
                pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_11762_, SoundSource.BLOCKS, 0.3f, 0.5f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, LIT, WATERLOGGED});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new StreetLampBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.f_46443_) {
            return (level, pos, state, blockEntity) -> {
                long tickCount = level.m_46467_();
                if (tickCount % 50L == 0L) {
                    ((StreetLampBlockEntity)blockEntity).tick(level, pos, state);
                }
            };
        }
        return null;
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return false;
    }

    @Override
    public boolean canConnect(BlockState pState, Direction pDirection) {
        return pDirection == Direction.DOWN;
    }

    public static enum LampType {
        NORMAL,
        SMALL,
        DOUBLE,
        SMALL_DOUBLE,
        SINGLE_LIGHT;

    }
}

