/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.AsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.RoadBlock;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PaintedAsphaltSlope
extends RoadBlock
implements SimpleWaterloggedBlock {
    private Block pickupBlock;
    public static final int MAX_HEIGHT = 8;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public static final int HEIGHT_IMPASSABLE = 5;

    public PaintedAsphaltSlope(RoadType type, Block pickupBlock) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(1.5f).m_60999_(), type);
        this.pickupBlock = pickupBlock;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return this.pickupBlock == null || this.pickupBlock == this ? super.m_7397_(level, pos, state) : this.pickupBlock.m_7397_(level, pos, state);
    }

    @Override
    public void m_6256_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        this.onRemoveColor(pState, pLevel, pPos, pPlayer);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        switch (pType) {
            case LAND: {
                return (Integer)pState.m_61143_((Property)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        int i = (Integer)pState.m_61143_((Property)LAYERS);
        Item item = pUseContext.m_43722_().m_41720_();
        if (item instanceof BlockItem) {
            Block block;
            BlockItem blockitem = (BlockItem)item;
            if (i < 8 && (block = blockitem.m_40614_()) instanceof AsphaltSlope) {
                AsphaltSlope selectedSlope = (AsphaltSlope)block;
                block = pState.m_60734_();
                if (block instanceof PaintedAsphaltSlope) {
                    PaintedAsphaltSlope targetSlope = (PaintedAsphaltSlope)block;
                    if (selectedSlope.getDefaultRoadType() == targetSlope.getDefaultRoadType()) {
                        if (pUseContext.m_7058_()) {
                            return pUseContext.m_43719_() == Direction.UP;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        boolean flag;
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean bl = flag = fluidstate.m_76152_() == Fluids.f_76193_;
        if (blockstate.m_60734_() instanceof AsphaltSlope) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)((BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LAYERS, WATERLOGGED});
        super.m_7926_(pBuilder);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    @Override
    public void onRemoveColor(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        ItemStack stack = pPlayer.m_150109_().m_36056_();
        Item item = stack.m_41720_();
        if (!(item instanceof BrushItem)) {
            return;
        }
        if (this == ModBlocks.ASPHALT_SLOPE.get() || this == ModBlocks.CONCRETE_SLOPE.get()) {
            return;
        }
        switch (this.getDefaultRoadType()) {
            case ASPHALT: {
                pLevel.m_46597_(pPos, (BlockState)((Block)ModBlocks.ASPHALT_SLOPE.get()).m_49966_().m_61124_((Property)LAYERS, (Comparable)((Integer)pState.m_61143_((Property)LAYERS))));
                pLevel.m_5594_(null, pPos, SoundEvents.f_12392_, SoundSource.BLOCKS, 0.8f, 2.0f);
                break;
            }
            case CONCRETE: {
                pLevel.m_46597_(pPos, (BlockState)((Block)ModBlocks.CONCRETE_SLOPE.get()).m_49966_().m_61124_((Property)LAYERS, (Comparable)((Integer)pState.m_61143_((Property)LAYERS))));
                pLevel.m_5594_(null, pPos, SoundEvents.f_12392_, SoundSource.BLOCKS, 0.8f, 2.0f);
                break;
            }
        }
    }
}

