/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.data.ColorableBlock;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GuardrailBlock
extends ColorableBlock
implements SimpleWaterloggedBlock,
ITrafficPostLike {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_POST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_XP_SOUTH = Block.m_49796_((double)9.0, (double)8.5, (double)5.5, (double)16.0, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_XN_SOUTH = Block.m_49796_((double)0.0, (double)8.5, (double)5.5, (double)7.0, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_XP_NORTH = Block.m_49796_((double)9.0, (double)8.5, (double)9.0, (double)16.0, (double)15.5, (double)10.5);
    private static final VoxelShape SHAPE_XN_NORTH = Block.m_49796_((double)0.0, (double)8.5, (double)9.0, (double)7.0, (double)15.5, (double)10.5);
    private static final VoxelShape SHAPE_ZP_EAST = Block.m_49796_((double)5.5, (double)8.5, (double)9.0, (double)7.0, (double)15.5, (double)16.0);
    private static final VoxelShape SHAPE_ZN_EAST = Block.m_49796_((double)5.5, (double)8.5, (double)0.0, (double)7.0, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_ZP_WEST = Block.m_49796_((double)9.0, (double)8.5, (double)9.0, (double)10.5, (double)15.5, (double)16.0);
    private static final VoxelShape SHAPE_ZN_WEST = Block.m_49796_((double)9.0, (double)8.5, (double)0.0, (double)10.5, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)5.5, (double)8.5, (double)5.5, (double)10.5, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.5, (double)8.5, (double)9.0, (double)10.5, (double)15.5, (double)10.5);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)5.5, (double)8.5, (double)5.5, (double)7.0, (double)15.5, (double)10.5);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)9.0, (double)8.5, (double)5.5, (double)10.5, (double)15.5, (double)10.5);
    private static final VoxelShape COLLISION_POST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)24.0, (double)9.0);
    private static final VoxelShape COLLISION_XP_SOUTH = Block.m_49796_((double)9.0, (double)8.5, (double)5.5, (double)16.0, (double)24.0, (double)7.0);
    private static final VoxelShape COLLISION_XN_SOUTH = Block.m_49796_((double)0.0, (double)8.5, (double)5.5, (double)7.0, (double)24.0, (double)7.0);
    private static final VoxelShape COLLISION_XP_NORTH = Block.m_49796_((double)9.0, (double)8.5, (double)9.0, (double)16.0, (double)24.0, (double)10.5);
    private static final VoxelShape COLLISION_XN_NORTH = Block.m_49796_((double)0.0, (double)8.5, (double)9.0, (double)7.0, (double)24.0, (double)10.5);
    private static final VoxelShape COLLISION_ZP_EAST = Block.m_49796_((double)5.5, (double)8.5, (double)9.0, (double)7.0, (double)24.0, (double)16.0);
    private static final VoxelShape COLLISION_ZN_EAST = Block.m_49796_((double)5.5, (double)8.5, (double)0.0, (double)7.0, (double)24.0, (double)7.0);
    private static final VoxelShape COLLISION_ZP_WEST = Block.m_49796_((double)9.0, (double)8.5, (double)9.0, (double)10.5, (double)24.0, (double)16.0);
    private static final VoxelShape COLLISION_ZN_WEST = Block.m_49796_((double)9.0, (double)8.5, (double)0.0, (double)10.5, (double)15.5, (double)7.0);
    private static final VoxelShape COLLISION_SOUTH = Block.m_49796_((double)5.5, (double)8.5, (double)5.5, (double)10.5, (double)24.0, (double)7.0);
    private static final VoxelShape COLLISION_NORTH = Block.m_49796_((double)5.5, (double)8.5, (double)9.0, (double)10.5, (double)24.0, (double)10.5);
    private static final VoxelShape COLLISION_EAST = Block.m_49796_((double)5.5, (double)8.5, (double)5.5, (double)7.0, (double)24.0, (double)10.5);
    private static final VoxelShape COLLISION_WEST = Block.m_49796_((double)9.0, (double)8.5, (double)5.5, (double)10.5, (double)24.0, (double)10.5);

    public GuardrailBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(2.0f).m_60918_(SoundType.f_56762_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        StairsShape shape = (StairsShape)pState.m_61143_(SHAPE);
        if (direction == Direction.NORTH && shape == StairsShape.STRAIGHT) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_NORTH, SHAPE_XN_NORTH, SHAPE_NORTH});
        }
        if (direction == Direction.SOUTH && shape == StairsShape.STRAIGHT) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_SOUTH, SHAPE_XN_SOUTH, SHAPE_SOUTH});
        }
        if (direction == Direction.EAST && shape == StairsShape.STRAIGHT) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_EAST, SHAPE_ZN_EAST, SHAPE_EAST});
        }
        if (direction == Direction.WEST && shape == StairsShape.STRAIGHT) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_WEST, SHAPE_ZN_WEST, SHAPE_WEST});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.NORTH) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_EAST, SHAPE_XN_NORTH});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.NORTH) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_WEST, SHAPE_XP_NORTH});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.EAST) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XN_SOUTH, SHAPE_ZN_EAST});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.EAST) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XN_NORTH, SHAPE_ZP_EAST});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.SOUTH) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZN_WEST, SHAPE_XP_SOUTH});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.SOUTH) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZN_EAST, SHAPE_XN_SOUTH});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.WEST) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_NORTH, SHAPE_ZP_WEST});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.WEST) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_SOUTH, SHAPE_ZN_WEST});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.NORTH) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZN_EAST, SHAPE_XP_NORTH, SHAPE_EAST, SHAPE_NORTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.NORTH) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZN_WEST, SHAPE_XN_NORTH, SHAPE_WEST, SHAPE_NORTH});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.EAST) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_SOUTH, SHAPE_ZP_EAST, SHAPE_SOUTH, SHAPE_EAST});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.EAST) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_NORTH, SHAPE_ZN_EAST, SHAPE_NORTH, SHAPE_EAST});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.SOUTH) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_WEST, SHAPE_XN_SOUTH, SHAPE_WEST, SHAPE_SOUTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.SOUTH) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_EAST, SHAPE_XP_SOUTH, SHAPE_EAST, SHAPE_SOUTH});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.WEST) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XN_NORTH, SHAPE_ZN_WEST, SHAPE_WEST, SHAPE_NORTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.WEST) {
            return Shapes.m_83124_((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XN_SOUTH, SHAPE_ZP_WEST, SHAPE_WEST, SHAPE_SOUTH});
        }
        return SHAPE_POST;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        StairsShape shape = (StairsShape)pState.m_61143_(SHAPE);
        if (direction == Direction.NORTH && shape == StairsShape.STRAIGHT) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_NORTH, COLLISION_XN_NORTH, COLLISION_NORTH});
        }
        if (direction == Direction.SOUTH && shape == StairsShape.STRAIGHT) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_SOUTH, COLLISION_XN_SOUTH, COLLISION_SOUTH});
        }
        if (direction == Direction.EAST && shape == StairsShape.STRAIGHT) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_EAST, COLLISION_ZN_EAST, COLLISION_EAST});
        }
        if (direction == Direction.WEST && shape == StairsShape.STRAIGHT) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_WEST, COLLISION_ZN_WEST, COLLISION_WEST});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.NORTH) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_EAST, COLLISION_XN_NORTH});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.NORTH) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_WEST, COLLISION_XP_NORTH});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.EAST) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XN_SOUTH, COLLISION_ZN_EAST});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.EAST) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XN_NORTH, COLLISION_ZP_EAST});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.SOUTH) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZN_WEST, COLLISION_XP_SOUTH});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.SOUTH) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZN_EAST, COLLISION_XN_SOUTH});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.WEST) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_NORTH, COLLISION_ZP_WEST});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.WEST) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_SOUTH, COLLISION_ZN_WEST});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.NORTH) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZN_EAST, COLLISION_XP_NORTH, COLLISION_EAST, COLLISION_NORTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.NORTH) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZN_WEST, COLLISION_XN_NORTH, COLLISION_WEST, COLLISION_NORTH});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.EAST) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_SOUTH, COLLISION_ZP_EAST, COLLISION_SOUTH, COLLISION_EAST});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.EAST) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_NORTH, COLLISION_ZN_EAST, COLLISION_NORTH, COLLISION_EAST});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.SOUTH) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_WEST, COLLISION_XN_SOUTH, COLLISION_WEST, COLLISION_SOUTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.SOUTH) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_EAST, COLLISION_XP_SOUTH, COLLISION_EAST, COLLISION_SOUTH});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.WEST) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XN_NORTH, COLLISION_ZN_WEST, COLLISION_WEST, COLLISION_NORTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.WEST) {
            return Shapes.m_83124_((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XN_SOUTH, COLLISION_ZP_WEST, COLLISION_WEST, COLLISION_SOUTH});
        }
        return COLLISION_POST;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)pState.m_61143_(SHAPE);
        switch (pMirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return pState.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return pState.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(pState, pMirror);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return pFacing.m_122434_().m_122479_() ? (BlockState)pState.m_61124_(SHAPE, (Comparable)GuardrailBlock.getGuardrailShape(pState, (BlockGetter)pLevel, pCurrentPos)) : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private static StairsShape getGuardrailShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(direction));
        if (GuardrailBlock.isGuardrail(blockstate) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)pState.m_61143_((Property)FACING)).m_122434_() && GuardrailBlock.canTakeShape(pState, pLevel, pPos, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = pLevel.m_8055_(pPos.m_121945_(direction.m_122424_()));
        if (GuardrailBlock.isGuardrail(blockstate1) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != ((Direction)pState.m_61143_((Property)FACING)).m_122434_() && GuardrailBlock.canTakeShape(pState, pLevel, pPos, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pFace) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(pFace));
        return !GuardrailBlock.isGuardrail(blockstate) || blockstate.m_61143_((Property)FACING) != pState.m_61143_((Property)FACING);
    }

    public static boolean isGuardrail(BlockState pState) {
        return pState.m_60734_() instanceof GuardrailBlock;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(blockpos);
        BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)GuardrailBlock.getGuardrailShape(blockstate, (BlockGetter)pContext.m_43725_(), blockpos));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    public int getDefaultColor() {
        return -8224126;
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return pDirection == ((Direction)pState.m_61143_((Property)FACING)).m_122424_();
    }
}

