/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.AsphaltCurbSlope;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.MapColor;

public class AsphaltCurb
extends Block {
    private RoadType defaultRoadType;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;

    public AsphaltCurb(RoadType type) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(1.5f).m_60999_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.defaultRoadType = type;
    }

    public RoadType getDefaultRoadType() {
        return this.defaultRoadType;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)pState.m_61143_(SHAPE);
        switch (pMirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return pState.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return pState.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(pState, pMirror);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing.m_122434_().m_122479_() ? (BlockState)pState.m_61124_(SHAPE, (Comparable)AsphaltCurb.getBlockShape(pState, (BlockGetter)pLevel, pCurrentPos)) : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private static StairsShape getBlockShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(direction));
        if (AsphaltCurb.isLikeThis(blockstate) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)pState.m_61143_((Property)FACING)).m_122434_() && AsphaltCurb.canTakeShape(pState, pLevel, pPos, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = pLevel.m_8055_(pPos.m_121945_(direction.m_122424_()));
        if (AsphaltCurb.isLikeThis(blockstate1) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != ((Direction)pState.m_61143_((Property)FACING)).m_122434_() && AsphaltCurb.canTakeShape(pState, pLevel, pPos, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pFace) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(pFace));
        return !AsphaltCurb.isLikeThis(blockstate) || blockstate.m_61143_((Property)FACING) != pState.m_61143_((Property)FACING);
    }

    public static boolean isLikeThis(BlockState pState) {
        return pState.m_60734_() instanceof AsphaltCurb || pState.m_60734_() instanceof AsphaltCurbSlope;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)AsphaltCurb.getBlockShape(blockstate, (BlockGetter)pContext.m_43725_(), blockpos));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, SHAPE});
    }
}

