/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon.breech;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AbstractAutocannonBreechBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AutocannonBreechBlock;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerBlock;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerItem;

public class AutocannonBreechInstance
extends BlockEntityInstance<AbstractAutocannonBreechBlockEntity>
implements DynamicInstance {
    private OrientedData ejector;
    private OrientedData seat;
    private OrientedData ammoContainer;
    private Direction facing;
    private boolean isFilled = false;
    private Item magazineItem = null;

    public AutocannonBreechInstance(MaterialManager manager, AbstractAutocannonBreechBlockEntity blockEntity) {
        super(manager, (BlockEntity)blockEntity);
    }

    public void init() {
        Quaternionf q1;
        super.init();
        this.facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        Quaternionf q = Axis.f_252436_.m_252977_(this.facing.m_122434_().m_122478_() ? 180.0f : 0.0f);
        this.ejector = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(this.getPartialModelForState(), this.blockState, this.facing).createInstance();
        this.ejector.setRotation(q);
        this.seat = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(CBCBlockPartials.autocannonSeatFor(((AbstractAutocannonBreechBlockEntity)this.blockEntity).getSeatColor()), this.blockState, this.facing).createInstance();
        this.seat.setRotation(q).setPosition(this.getInstancePosition());
        this.ammoContainer = (OrientedData)this.materialManager.defaultCutout().material(Materials.ORIENTED).getModel(this.getAmmoContainerModel()).createInstance();
        boolean flag = this.facing.m_122434_().m_122478_();
        if (flag) {
            float f = this.facing == Direction.UP ? 90.0f : -90.0f;
            q1 = Axis.f_252403_.m_252977_(f);
            q1.mul((Quaternionfc)Axis.f_252529_.m_252977_(f));
        } else {
            q1 = Axis.f_252436_.m_252977_(-90.0f - this.facing.m_122435_());
        }
        Direction offset = flag ? this.facing.m_175364_(Direction.Axis.Z) : this.facing.m_175362_(Direction.Axis.Y);
        Vector3f normal = this.facing == Direction.UP ? offset.m_122424_().m_253071_() : offset.m_253071_();
        normal.mul(0.625f);
        this.ammoContainer.setRotation(q1).setPosition(this.getInstancePosition()).nudge(normal.x(), normal.y(), normal.z());
        this.isFilled = this.isFilled();
        this.magazineItem = this.getMagazineItem();
        this.updateTransforms();
    }

    public void beginFrame() {
        this.updateTransforms();
    }

    private void updateTransforms() {
        if (((Boolean)this.blockState.m_61143_((Property)AutocannonBreechBlock.HANDLE)).booleanValue()) {
            this.ejector.setColor((byte)-1, (byte)-1, (byte)-1, (byte)0);
            this.seat.setColor((byte)-1, (byte)-1, (byte)-1, (byte)(((AbstractAutocannonBreechBlockEntity)this.blockEntity).getSeatColor() == null ? 0 : 255));
        } else {
            this.seat.setColor((byte)-1, (byte)-1, (byte)-1, (byte)0);
            float offset = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getAnimateOffset(AnimationTickHolder.getPartialTicks()) * 0.5f;
            Vector3f normal = this.facing.m_122424_().m_253071_();
            normal.mul(offset);
            this.ejector.setPosition(this.getInstancePosition()).nudge(normal.x(), normal.y(), normal.z()).setColor((byte)-1, (byte)-1, (byte)-1, (byte)-1);
        }
        ItemStack container = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        this.ammoContainer.setColor((byte)-1, (byte)-1, (byte)-1, (byte)(container.m_41720_() instanceof AutocannonAmmoContainerItem ? 255 : 0));
        if (this.isFilled != this.isFilled() || this.magazineItem != this.getMagazineItem()) {
            this.remove();
            this.init();
            this.updateLight();
        }
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.ejector});
        this.relight(this.pos, new FlatLit[]{this.seat});
        this.relight(this.pos, new FlatLit[]{this.ammoContainer});
    }

    protected void remove() {
        this.ejector.delete();
        this.seat.delete();
        this.ammoContainer.delete();
    }

    private PartialModel getPartialModelForState() {
        PartialModel partialModel;
        Block block = this.blockState.m_60734_();
        if (block instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block;
            partialModel = CBCBlockPartials.autocannonEjectorFor(cBlock.getAutocannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_AUTOCANNON_EJECTOR;
        }
        return partialModel;
    }

    private BlockState getAmmoContainerModel() {
        Item item;
        ItemStack item2 = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        if (item2 == null || item2.m_41619_() || !((item = item2.m_41720_()) instanceof AutocannonAmmoContainerItem)) {
            return Blocks.f_50016_.m_49966_();
        }
        AutocannonAmmoContainerItem blockItem = (AutocannonAmmoContainerItem)item;
        BlockState state = blockItem.m_40614_().m_49966_();
        if (state.m_61138_(AutocannonAmmoContainerBlock.CONTAINER_STATE)) {
            state = (BlockState)state.m_61124_(AutocannonAmmoContainerBlock.CONTAINER_STATE, (Comparable)((Object)AutocannonAmmoContainerBlock.State.getFromFilled(AutocannonAmmoContainerItem.getTotalAmmoCount(item2) > 0)));
        }
        return state;
    }

    private boolean isFilled() {
        return AutocannonAmmoContainerItem.getTotalAmmoCount(((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine()) > 0;
    }

    private Item getMagazineItem() {
        ItemStack stack = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        return stack == null || stack.m_41619_() ? null : stack.m_41720_();
    }
}

