/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.ingotcraft.init;

import com.jahirtrap.ingotcraft.init.ModMaterials;
import com.jahirtrap.ingotcraft.init.ModTiers;
import com.jahirtrap.ingotcraft.item.BaseArmorItem;
import com.jahirtrap.ingotcraft.item.BasePickHammerItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModContent {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"ingotcraft");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"ingotcraft");
    public static final RegistryObject<Item> RAW_STEEL = ModContent.registerItem("raw_steel", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> RAW_BRONZE = ModContent.registerItem("raw_bronze", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> RAW_LEAD = ModContent.registerItem("raw_lead", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> RAW_SILVER = ModContent.registerItem("raw_silver", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> RAW_TIN = ModContent.registerItem("raw_tin", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Block> RAW_STEEL_BLOCK = ModContent.registerBlock("raw_steel_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Block> RAW_BRONZE_BLOCK = ModContent.registerBlock("raw_bronze_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Block> RAW_LEAD_BLOCK = ModContent.registerBlock("raw_lead_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Block> RAW_SILVER_BLOCK = ModContent.registerBlock("raw_silver_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Block> RAW_TIN_BLOCK = ModContent.registerBlock("raw_tin_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283765_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Item> STEEL_INGOT = ModContent.registerItem("steel_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> BRONZE_INGOT = ModContent.registerItem("bronze_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> LEAD_INGOT = ModContent.registerItem("lead_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SILVER_INGOT = ModContent.registerItem("silver_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> TIN_INGOT = ModContent.registerItem("tin_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Block> STEEL_BLOCK = ModContent.registerBlock("steel_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Block> BRONZE_BLOCK = ModContent.registerBlock("bronze_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Block> LEAD_BLOCK = ModContent.registerBlock("lead_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60918_(SoundType.f_154663_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Block> SILVER_BLOCK = ModContent.registerBlock("silver_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Block> TIN_BLOCK = ModContent.registerBlock("tin_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283765_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 6.0f).m_60999_()), new Item.Properties());
    public static final RegistryObject<Item> STEEL_NUGGET = ModContent.registerItem("steel_nugget", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> BRONZE_NUGGET = ModContent.registerItem("bronze_nugget", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> LEAD_NUGGET = ModContent.registerItem("lead_nugget", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SILVER_NUGGET = ModContent.registerItem("silver_nugget", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> TIN_NUGGET = ModContent.registerItem("tin_nugget", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> COPPER_NUGGET = ModContent.registerItem("copper_nugget", () -> new Item(new Item.Properties()));
    public static final List<RegistryObject<Item>> STEEL_TOOLS = ModContent.registerTools("steel", ModTiers.STEEL, new float[]{6.0f, -3.0f, -2.0f, -1.0f}, new Item.Properties());
    public static final List<RegistryObject<Item>> BRONZE_TOOLS = ModContent.registerTools("bronze", ModTiers.BRONZE, new float[]{6.0f, -3.0f, -2.0f, -1.0f}, new Item.Properties());
    public static final List<RegistryObject<Item>> STEEL_ARMOR = ModContent.registerArmor(ModMaterials.STEEL, new Item.Properties());
    public static final List<RegistryObject<Item>> BRONZE_ARMOR = ModContent.registerArmor(ModMaterials.BRONZE, new Item.Properties());
    public static final RegistryObject<Item> STONE_PICK_HAMMER = ModContent.registerItem("stone_pick_hammer", () -> new BasePickHammerItem(ModTiers.STONE_PICK_HAMMER, new Item.Properties()));
    public static final RegistryObject<Item> IRON_PICK_HAMMER = ModContent.registerItem("iron_pick_hammer", () -> new BasePickHammerItem(ModTiers.IRON_PICK_HAMMER, new Item.Properties()));
    public static final RegistryObject<Item> GOLDEN_PICK_HAMMER = ModContent.registerItem("golden_pick_hammer", () -> new BasePickHammerItem(ModTiers.GOLD_PICK_HAMMER, new Item.Properties()));
    public static final RegistryObject<Item> DIAMOND_PICK_HAMMER = ModContent.registerItem("diamond_pick_hammer", () -> new BasePickHammerItem(ModTiers.DIAMOND_PICK_HAMMER, new Item.Properties()));
    public static final RegistryObject<Item> NETHERITE_PICK_HAMMER = ModContent.registerItem("netherite_pick_hammer", () -> new BasePickHammerItem(ModTiers.NETHERITE_PICK_HAMMER, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> ENDERITE_PICK_HAMMER = ModContent.registerItem("enderite_pick_hammer", () -> new BasePickHammerItem(ModTiers.ENDERITE_PICK_HAMMER, new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> STEEL_PICK_HAMMER = ModContent.registerItem("steel_pick_hammer", () -> new BasePickHammerItem(ModTiers.STEEL_PICK_HAMMER, new Item.Properties()));
    public static final RegistryObject<Item> BRONZE_PICK_HAMMER = ModContent.registerItem("bronze_pick_hammer", () -> new BasePickHammerItem(ModTiers.BRONZE_PICK_HAMMER, new Item.Properties()));
    public static final RegistryObject<Item> ZURITE_PICK_HAMMER = ModContent.registerItem("zurite_pick_hammer", () -> new BasePickHammerItem(ModTiers.ZURITE_PICK_HAMMER, new Item.Properties().m_41486_()));

    private static RegistryObject<Block> registerBlock(String name, Supplier<Block> supplier, Item.Properties itemProp) {
        RegistryObject<Block> blockReg = ModContent.registerBlock(name, supplier);
        ModContent.registerItem(name, () -> new BlockItem((Block)blockReg.get(), itemProp));
        return blockReg;
    }

    private static RegistryObject<Block> registerBlock(String name, Supplier<Block> supplier) {
        return BLOCKS.register(name, supplier);
    }

    private static RegistryObject<Item> registerItem(String name, Supplier<Item> supplier) {
        return ITEMS.register(name, supplier);
    }

    private static List<RegistryObject<Item>> registerTools(String name, Tier tier, float[] attr, Item.Properties itemProp) {
        return List.of(ModContent.registerItem(name + "_sword", () -> new SwordItem(tier, 3, -2.4f, itemProp)), ModContent.registerItem(name + "_pickaxe", () -> new PickaxeItem(tier, 1, -2.8f, itemProp)), ModContent.registerItem(name + "_axe", () -> new AxeItem(tier, attr[0], attr[1], itemProp)), ModContent.registerItem(name + "_shovel", () -> new ShovelItem(tier, 1.5f, -3.0f, itemProp)), ModContent.registerItem(name + "_hoe", () -> new HoeItem(tier, (int)attr[2], attr[3], itemProp)));
    }

    private static List<RegistryObject<Item>> registerArmor(ArmorMaterial material, Item.Properties itemProp) {
        String name = material.m_6082_().substring(material.m_6082_().indexOf(58) + 1);
        return List.of(ModContent.registerItem(name + "_helmet", () -> new BaseArmorItem(material, ArmorItem.Type.HELMET, itemProp)), ModContent.registerItem(name + "_chestplate", () -> new BaseArmorItem(material, ArmorItem.Type.CHESTPLATE, itemProp)), ModContent.registerItem(name + "_leggings", () -> new BaseArmorItem(material, ArmorItem.Type.LEGGINGS, itemProp)), ModContent.registerItem(name + "_boots", () -> new BaseArmorItem(material, ArmorItem.Type.BOOTS, itemProp)));
    }

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
    }
}

