/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.content.distant_signals.SignalDisplaySource;
import com.railwayteam.railways.mixin.AccessorBlockEntityType;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.forge.CRExtraRegistrationImpl;
import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CRExtraRegistration {
    public static boolean registeredSignalSource = false;
    public static boolean registeredVentAsCopycat = false;

    public static void register() {
        CRExtraRegistration.platformSpecificRegistration();
        CRExtraRegistration.addSignalSource();
    }

    public static void addVentAsCopycat(BlockEntityType<?> object) {
        Block ventBlock;
        if (registeredVentAsCopycat) {
            return;
        }
        try {
            ventBlock = (Block)CRBlocks.CONDUCTOR_VENT.get();
        }
        catch (NullPointerException ignored) {
            return;
        }
        ImmutableSet validBlocks = ((AccessorBlockEntityType)object).getValidBlocks();
        validBlocks = new ImmutableSet.Builder().add((Object[])((Block[])validBlocks.toArray(Block[]::new))).add((Object)ventBlock).build();
        ((AccessorBlockEntityType)object).setValidBlocks((Set<Block>)validBlocks);
        registeredVentAsCopycat = true;
    }

    public static void addSignalSource() {
        if (registeredSignalSource) {
            return;
        }
        DisplayBehaviour signalDisplaySource = AllDisplayBehaviours.register((ResourceLocation)Create.asResource((String)"track_signal_source"), (DisplayBehaviour)new SignalDisplaySource());
        AllDisplayBehaviours.assignBlock((DisplayBehaviour)signalDisplaySource, (ResourceLocation)Create.asResource((String)"track_signal"));
        registeredSignalSource = true;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void platformSpecificRegistration() {
        CRExtraRegistrationImpl.platformSpecificRegistration();
    }
}

