/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuHandlerServer;
import com.railwayteam.railways.content.custom_tracks.CustomTrackBlock;
import com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionUtils;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackBlock;
import com.railwayteam.railways.content.roller_extensions.TrackReplacePaver;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TrackBlock.class}, remap=false)
public class MixinTrackBlock {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void extendedUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult result;
        if (!(this instanceof MonorailTrackBlock) && (result = CustomTrackBlock.casingUse(state, world, pos, player, hand, hit)) != null) {
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"getBogeyAnchor"}, at={@At(value="HEAD")}, cancellable=true)
    private void placeCustomStyle(BlockGetter world, BlockPos pos, BlockState state, CallbackInfoReturnable<BlockState> cir) {
        TrackMaterial.TrackType trackType;
        if (BogeyMenuHandlerServer.getCurrentPlayer() == null) {
            return;
        }
        Pair<BogeyStyle, BogeySizes.BogeySize> styleData = BogeyMenuHandlerServer.getStyle(BogeyMenuHandlerServer.getCurrentPlayer());
        BogeyStyle style = (BogeyStyle)styleData.getFirst();
        Optional<BogeyStyle> mappedStyleOptional = CRBogeyStyles.getMapped(style, trackType = ((TrackBlock)this).getMaterial().trackType, true);
        if (mappedStyleOptional.isPresent()) {
            style = mappedStyleOptional.get();
        }
        BogeySizes.BogeySize selectedSize = (BogeySizes.BogeySize)styleData.getSecond();
        if (style == AllBogeyStyles.STANDARD) {
            return;
        }
        BogeySizes.BogeySize size = selectedSize != null ? selectedSize : (BogeySizes.BogeySize)BogeySizes.getAllSizesSmallToLarge().get(0);
        int escape = BogeySizes.getAllSizesSmallToLarge().size();
        while (!style.validSizes().contains(size)) {
            if (escape < 0) {
                return;
            }
            size = size.increment();
            --escape;
        }
        Block block = style.getBlockOfSize(size);
        cir.setReturnValue((Object)((BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)(state.m_61143_((Property)TrackBlock.SHAPE) == TrackShape.XO ? Direction.Axis.X : Direction.Axis.Z))));
    }

    @Redirect(method={"onPlace"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;scheduleTick(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;I)V", remap=true), remap=true)
    private void maybeMakeTickInstant(Level instance, BlockPos blockPos, Block block, int i) {
        if (TrackReplacePaver.tickInstantly) {
            i = 0;
        }
        instance.m_186460_(blockPos, block, i);
    }

    @Inject(method={"getCollisionShape"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void casingCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext, CallbackInfoReturnable<VoxelShape> cir) {
        TrackBlockEntity tbe;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof TrackBlockEntity && CasingCollisionUtils.shouldMakeCollision(tbe = (TrackBlockEntity)blockEntity, pState)) {
            cir.setReturnValue((Object)CRShapes.BOTTOM_SLAB);
        }
    }

    @Inject(method={"onRemove"}, at={@At(value="HEAD")}, remap=true)
    private void removeCasingCollisions(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving, CallbackInfo ci) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof TrackBlockEntity) {
            TrackBlockEntity tbe = (TrackBlockEntity)blockEntity;
            CasingCollisionUtils.manageTracks(tbe, true);
        }
    }
}

