/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.network;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public abstract class SimpleNetworkHandler<C, T extends SimpleNetworkHandler<C, T>>
extends LocalNetworkHandler
implements IWorldTickable {
    private Set<C> allConnectors = new HashSet<C>();
    private boolean needsUpdate = true;

    protected SimpleNetworkHandler(LocalWireNetwork net, GlobalWireNetwork global) {
        super(net, global);
    }

    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        this.reset();
        return this;
    }

    public void onConnectorLoaded(ConnectionPoint p, IImmersiveConnectable iic) {
        this.reset();
    }

    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    public void onConnectionAdded(Connection c) {
        this.reset();
    }

    public void onConnectionRemoved(Connection c) {
        this.reset();
    }

    public void update(Level w) {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            for (ConnectionPoint cp : this.localNet.getConnectionPoints()) {
                IImmersiveConnectable iic = this.localNet.getConnector(cp);
                C c2 = this.connect(iic);
                if (c2 == null) continue;
                this.allConnectors.add(c2);
            }
            this.allConnectors.forEach(c -> this.setNetworkHandler(c, this));
        }
    }

    protected abstract C connect(IImmersiveConnectable var1);

    private void reset() {
        this.allConnectors.forEach(c -> this.setNetworkHandler(c, null));
        this.allConnectors.clear();
        this.needsUpdate = true;
    }

    public void visitAll(Consumer<C> forEach) {
        this.allConnectors.forEach(forEach);
    }

    protected abstract void setNetworkHandler(C var1, T var2);
}

