/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires;

import com.tom.morewires.Config;
import com.tom.morewires.MoreImmersiveWiresClient;
import com.tom.morewires.SimpleWireTypeDefinition;
import com.tom.morewires.WireTypeDefinition;
import com.tom.morewires.compat.ae.AEDenseWireDefinition;
import com.tom.morewires.compat.ae.AEWireDefinition;
import com.tom.morewires.compat.cc.CCWireDefinition;
import com.tom.morewires.compat.id.IntegratedDynamicsWireDefinition;
import com.tom.morewires.compat.rs.RSWireDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="more_immersive_wires")
public class MoreImmersiveWires {
    public static final String modid = "more_immersive_wires";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"more_immersive_wires");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"more_immersive_wires");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"more_immersive_wires");
    public static final DeferredRegister<CreativeModeTab> TAB = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"more_immersive_wires");
    public static final Map<BlockEntityType<?>, WireTypeDefinition.RelayInfo> WIRE_TYPES = new HashMap();
    public static final List<Wire> ALL_WIRES = new ArrayList<Wire>();
    public static final String AE = "ae2";
    public static final String RS = "refinedstorage";
    public static final String ID = "integrateddynamics";
    public static final String CC = "computercraft";
    public static final String FTBIC = "ftbic";
    public static final String IC2 = "ic2";
    public static final Wire AE_WIRE = new Wire("ae2", () -> AEWireDefinition::new);
    public static final Wire AE_DENSE_WIRE = new Wire("ae2", () -> AEDenseWireDefinition::new);
    public static final Wire RS_WIRE = new Wire("refinedstorage", () -> RSWireDefinition::new);
    public static final Wire ID_WIRE = new Wire("integrateddynamics", () -> IntegratedDynamicsWireDefinition::new);
    public static final Wire CC_WIRE = new Wire("computercraft", () -> CCWireDefinition::new);
    public static final Logger LOGGER = LogManager.getLogger();
    public static Map<String, String> MODID_NAME_LOOKUP = Collections.emptyMap();
    private static List<Item> tabItems = new ArrayList<Item>();
    public static final RegistryObject<CreativeModeTab> STORAGE_MOD_TAB = TAB.register("tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.more_immersive_wires.tab")).m_257737_(() -> ALL_WIRES.stream().flatMap(w -> w.wireTypeDef.getWireCoils().stream()).map(w -> new ItemStack((ItemLike)w.getCoilItem().get())).findFirst().orElse(new ItemStack((ItemLike)Items.f_42451_))).m_257501_((p, out) -> tabItems.forEach(arg_0 -> ((CreativeModeTab.Output)out).m_246326_(arg_0))).m_257652_());

    public MoreImmersiveWires() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> MoreImmersiveWiresClient::preInit);
        ALL_WIRES.forEach(Wire::init);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        FMLJavaModLoadingContext.get().getModEventBus().register(Config.class);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BLOCK_ENTITIES.register(bus);
        TAB.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("More Immersive Wires Setup starting");
        ALL_WIRES.forEach(Wire::setup);
        MODID_NAME_LOOKUP = ModList.get().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, IModInfo::getDisplayName));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MoreImmersiveWiresClient.clientSetup();
    }

    public void enqueueIMC(InterModEnqueueEvent e) {
    }

    public static <I extends Item> I addItemToTab(I item) {
        tabItems.add(item);
        return item;
    }

    public static <B extends Block> RegistryObject<B> blockWithItem(String name, Supplier<B> create) {
        RegistryObject re = BLOCKS.register(name, create);
        ITEMS.register(name, () -> MoreImmersiveWires.addItemToTab(new BlockItem((Block)re.get(), new Item.Properties())));
        return re;
    }

    public static <B extends Block, I extends Item> RegistryObject<B> blockWithItem(String name, Supplier<B> create, Function<Block, I> createItem) {
        RegistryObject re = BLOCKS.register(name, create);
        ITEMS.register(name, () -> MoreImmersiveWires.addItemToTab((Item)createItem.apply((Block)re.get())));
        return re;
    }

    public static RegistryObject<Item> materialItem(String name) {
        return ITEMS.register(name, () -> MoreImmersiveWires.addItemToTab(new Item(new Item.Properties())));
    }

    @SafeVarargs
    public static <BE extends BlockEntity> RegistryObject<BlockEntityType<BE>> blockEntity(String name, BlockEntityType.BlockEntitySupplier<? extends BE> create, RegistryObject<? extends Block> ... blocks) {
        return BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)create, (Block[])((Block[])Arrays.stream(blocks).map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null));
    }

    public static <I extends Item> RegistryObject<Item> registerItem(String name, Supplier<I> object) {
        return ITEMS.register(name, () -> MoreImmersiveWires.addItemToTab((Item)object.get()));
    }

    public static class Wire {
        public final String modid;
        public WireTypeDefinition<?> wireTypeDef;

        public Wire(String modid, Supplier<Supplier<WireTypeDefinition<?>>> createDef) {
            this.modid = modid;
            if (ModList.get().isLoaded(modid)) {
                ALL_WIRES.add(this);
                this.wireTypeDef = createDef.get().get();
            }
        }

        public void init() {
            this.wireTypeDef.init();
        }

        public void setup() {
            this.wireTypeDef.setup(this);
        }

        public void config(ForgeConfigSpec.Builder builder) {
            this.wireTypeDef.config(builder);
        }

        public SimpleWireTypeDefinition<?> simple() {
            return (SimpleWireTypeDefinition)this.wireTypeDef;
        }
    }
}

