/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.filter;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.logistics.filter.attribute.BookAuthorAttribute;
import com.simibubi.create.content.logistics.filter.attribute.BookCopyAttribute;
import com.simibubi.create.content.logistics.filter.attribute.ColorAttribute;
import com.simibubi.create.content.logistics.filter.attribute.EnchantAttribute;
import com.simibubi.create.content.logistics.filter.attribute.FluidContentsAttribute;
import com.simibubi.create.content.logistics.filter.attribute.ItemNameAttribute;
import com.simibubi.create.content.logistics.filter.attribute.ShulkerFillLevelAttribute;
import com.simibubi.create.content.logistics.filter.attribute.astralsorcery.AstralSorceryAmuletAttribute;
import com.simibubi.create.content.logistics.filter.attribute.astralsorcery.AstralSorceryAttunementAttribute;
import com.simibubi.create.content.logistics.filter.attribute.astralsorcery.AstralSorceryCrystalAttribute;
import com.simibubi.create.content.logistics.filter.attribute.astralsorcery.AstralSorceryPerkGemAttribute;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public interface ItemAttribute {
    public static final List<ItemAttribute> types = new ArrayList<ItemAttribute>();
    public static final ItemAttribute standard = ItemAttribute.register(StandardTraits.DUMMY);
    public static final ItemAttribute inTag = ItemAttribute.register(new InTag((TagKey<Item>)ItemTags.f_13182_));
    public static final ItemAttribute inItemGroup = ItemAttribute.register(InItemGroup.EMPTY);
    public static final ItemAttribute addedBy = ItemAttribute.register(new AddedBy("dummy"));
    public static final ItemAttribute hasEnchant = ItemAttribute.register(EnchantAttribute.EMPTY);
    public static final ItemAttribute shulkerFillLevel = ItemAttribute.register(ShulkerFillLevelAttribute.EMPTY);
    public static final ItemAttribute hasColor = ItemAttribute.register(ColorAttribute.EMPTY);
    public static final ItemAttribute hasFluid = ItemAttribute.register(FluidContentsAttribute.EMPTY);
    public static final ItemAttribute hasName = ItemAttribute.register(new ItemNameAttribute("dummy"));
    public static final ItemAttribute bookAuthor = ItemAttribute.register(new BookAuthorAttribute("dummy"));
    public static final ItemAttribute bookCopy = ItemAttribute.register(new BookCopyAttribute(-1));
    public static final ItemAttribute astralAmulet = ItemAttribute.register(new AstralSorceryAmuletAttribute("dummy", -1));
    public static final ItemAttribute astralAttunement = ItemAttribute.register(new AstralSorceryAttunementAttribute("dummy"));
    public static final ItemAttribute astralCrystal = ItemAttribute.register(new AstralSorceryCrystalAttribute("dummy"));
    public static final ItemAttribute astralPerkGem = ItemAttribute.register(new AstralSorceryPerkGemAttribute("dummy"));

    public static ItemAttribute register(ItemAttribute attributeType) {
        types.add(attributeType);
        return attributeType;
    }

    @Nullable
    public static ItemAttribute fromNBT(CompoundTag nbt) {
        for (ItemAttribute itemAttribute : types) {
            if (!itemAttribute.canRead(nbt)) continue;
            return itemAttribute.readNBT(nbt.m_128469_(itemAttribute.getNBTKey()));
        }
        return null;
    }

    default public boolean appliesTo(ItemStack stack, Level world) {
        return this.appliesTo(stack);
    }

    public boolean appliesTo(ItemStack var1);

    default public List<ItemAttribute> listAttributesOf(ItemStack stack, Level world) {
        return this.listAttributesOf(stack);
    }

    public List<ItemAttribute> listAttributesOf(ItemStack var1);

    public String getTranslationKey();

    public void writeNBT(CompoundTag var1);

    public ItemAttribute readNBT(CompoundTag var1);

    default public void serializeNBT(CompoundTag nbt) {
        CompoundTag compound = new CompoundTag();
        this.writeNBT(compound);
        nbt.m_128365_(this.getNBTKey(), (Tag)compound);
    }

    default public Object[] getTranslationParameters() {
        return new String[0];
    }

    default public boolean canRead(CompoundTag nbt) {
        return nbt.m_128441_(this.getNBTKey());
    }

    default public String getNBTKey() {
        return this.getTranslationKey();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public MutableComponent format(boolean inverted) {
        return Lang.translateDirect("item_attributes." + this.getTranslationKey() + (inverted ? ".inverted" : ""), this.getTranslationParameters());
    }

    public static enum StandardTraits implements ItemAttribute
    {
        DUMMY(s -> false),
        PLACEABLE(s -> s.m_41720_() instanceof BlockItem),
        CONSUMABLE(ItemStack::m_41614_),
        FLUID_CONTAINER(s -> s.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()),
        ENCHANTED(ItemStack::m_41793_),
        MAX_ENCHANTED(StandardTraits::maxEnchanted),
        RENAMED(ItemStack::m_41788_),
        DAMAGED(ItemStack::m_41768_),
        BADLY_DAMAGED(s -> s.m_41768_() && (float)s.m_41773_() / (float)s.m_41776_() > 0.75f),
        NOT_STACKABLE(((Predicate<ItemStack>)ItemStack::m_41753_).negate()),
        EQUIPABLE(s -> LivingEntity.m_147233_((ItemStack)s).m_20743_() != EquipmentSlot.Type.HAND),
        FURNACE_FUEL(AbstractFurnaceBlockEntity::m_58399_),
        WASHABLE(AllFanProcessingTypes.SPLASHING::canProcess),
        HAUNTABLE(AllFanProcessingTypes.HAUNTING::canProcess),
        CRUSHABLE((s, w) -> StandardTraits.testRecipe(s, w, AllRecipeTypes.CRUSHING.getType()) || StandardTraits.testRecipe(s, w, AllRecipeTypes.MILLING.getType())),
        SMELTABLE((s, w) -> StandardTraits.testRecipe(s, w, (RecipeType<? extends Recipe<Container>>)RecipeType.f_44108_)),
        SMOKABLE((s, w) -> StandardTraits.testRecipe(s, w, (RecipeType<? extends Recipe<Container>>)RecipeType.f_44110_)),
        BLASTABLE((s, w) -> StandardTraits.testRecipe(s, w, (RecipeType<? extends Recipe<Container>>)RecipeType.f_44109_)),
        COMPOSTABLE(s -> ComposterBlock.f_51914_.containsKey((Object)s.m_41720_()));

        private static final RecipeWrapper RECIPE_WRAPPER;
        private Predicate<ItemStack> test;
        private BiPredicate<ItemStack, Level> testWithWorld;

        private StandardTraits(Predicate<ItemStack> test) {
            this.test = test;
        }

        private static boolean testRecipe(ItemStack s, Level w, RecipeType<? extends Recipe<Container>> type) {
            RECIPE_WRAPPER.m_6836_(0, s.m_41777_());
            return w.m_7465_().m_44015_(type, (Container)RECIPE_WRAPPER, w).isPresent();
        }

        private static boolean maxEnchanted(ItemStack s) {
            return EnchantmentHelper.m_44831_((ItemStack)s).entrySet().stream().anyMatch(e -> ((Enchantment)e.getKey()).m_6586_() <= (Integer)e.getValue());
        }

        private StandardTraits(BiPredicate<ItemStack, Level> test) {
            this.testWithWorld = test;
        }

        @Override
        public boolean appliesTo(ItemStack stack, Level world) {
            if (this.testWithWorld != null) {
                return this.testWithWorld.test(stack, world);
            }
            return this.appliesTo(stack);
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return this.test.test(stack);
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack, Level world) {
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            for (StandardTraits trait : StandardTraits.values()) {
                if (!trait.appliesTo(stack, world)) continue;
                attributes.add(trait);
            }
            return attributes;
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            return null;
        }

        @Override
        public String getTranslationKey() {
            return Lang.asId(this.name());
        }

        @Override
        public String getNBTKey() {
            return "standard_trait";
        }

        @Override
        public void writeNBT(CompoundTag nbt) {
            nbt.m_128379_(this.name(), true);
        }

        @Override
        public ItemAttribute readNBT(CompoundTag nbt) {
            for (StandardTraits trait : StandardTraits.values()) {
                if (!nbt.m_128441_(trait.name())) continue;
                return trait;
            }
            return null;
        }

        static {
            RECIPE_WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
        }
    }

    public static class InTag
    implements ItemAttribute {
        public TagKey<Item> tag;

        public InTag(TagKey<Item> tag) {
            this.tag = tag;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            return stack.m_204131_().map(InTag::new).collect(Collectors.toList());
        }

        @Override
        public String getTranslationKey() {
            return "in_tag";
        }

        @Override
        public Object[] getTranslationParameters() {
            return new Object[]{"#" + this.tag.f_203868_()};
        }

        @Override
        public void writeNBT(CompoundTag nbt) {
            nbt.m_128359_("space", this.tag.f_203868_().m_135827_());
            nbt.m_128359_("path", this.tag.f_203868_().m_135815_());
        }

        @Override
        public ItemAttribute readNBT(CompoundTag nbt) {
            return new InTag((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation(nbt.m_128461_("space"), nbt.m_128461_("path"))));
        }
    }

    public static class InItemGroup
    implements ItemAttribute {
        public static final InItemGroup EMPTY = new InItemGroup(null);
        private CreativeModeTab group;

        public InItemGroup(CreativeModeTab group) {
            this.group = group;
        }

        @Override
        public boolean appliesTo(ItemStack stack, Level world) {
            if (this.group == null) {
                return false;
            }
            if (this.group.m_260957_().isEmpty() && this.group.m_261235_().isEmpty()) {
                try {
                    this.group.m_269498_(new CreativeModeTab.ItemDisplayParameters(world.m_246046_(), false, (HolderLookup.Provider)world.m_9598_()));
                }
                catch (LinkageError | RuntimeException e) {
                    Create.LOGGER.error("Attribute Filter: Item Group crashed while building contents.", (Object)this.group.m_40786_().getString(), (Object)e);
                    this.group = null;
                    return false;
                }
            }
            return InItemGroup.tabContainsItem(this.group, stack);
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return false;
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            return CreativeModeTabs.m_257388_().stream().filter(tab -> tab.m_257962_() == CreativeModeTab.Type.CATEGORY).filter(tab -> InItemGroup.tabContainsItem(tab, stack)).map(tab -> new InItemGroup((CreativeModeTab)tab)).toList();
        }

        private static boolean tabContainsItem(CreativeModeTab tab, ItemStack stack) {
            return tab.m_257694_(stack) || tab.m_257694_(new ItemStack((ItemLike)stack.m_41720_()));
        }

        @Override
        public String getTranslationKey() {
            return "in_item_group";
        }

        @Override
        public Object[] getTranslationParameters() {
            return new Object[]{this.group == null ? "<none>" : this.group.m_40786_().getString()};
        }

        @Override
        public void writeNBT(CompoundTag nbt) {
            ResourceLocation groupId;
            if (this.group != null && (groupId = CreativeModeTabRegistry.getName((CreativeModeTab)this.group)) != null) {
                nbt.m_128359_("group", groupId.toString());
            }
        }

        @Override
        public ItemAttribute readNBT(CompoundTag nbt) {
            return nbt.m_128441_("group") ? new InItemGroup(CreativeModeTabRegistry.getTab((ResourceLocation)new ResourceLocation(nbt.m_128461_("group")))) : EMPTY;
        }
    }

    public static class AddedBy
    implements ItemAttribute {
        private String modId;

        public AddedBy(String modId) {
            this.modId = modId;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return this.modId.equals(stack.m_41720_().getCreatorModId(stack));
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            String id = stack.m_41720_().getCreatorModId(stack);
            return id == null ? Collections.emptyList() : Arrays.asList(new AddedBy(id));
        }

        @Override
        public String getTranslationKey() {
            return "added_by";
        }

        @Override
        public Object[] getTranslationParameters() {
            Optional modContainerById = ModList.get().getModContainerById(this.modId);
            String name = modContainerById.map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(StringUtils.capitalize((String)this.modId));
            return new Object[]{name};
        }

        @Override
        public void writeNBT(CompoundTag nbt) {
            nbt.m_128359_("id", this.modId);
        }

        @Override
        public ItemAttribute readNBT(CompoundTag nbt) {
            return new AddedBy(nbt.m_128461_("id"));
        }
    }
}

