/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.client.screen.menu.TrafficSignWorkbenchMenu;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.item.PatternCatalogueItem;
import de.mrjulsen.trafficcraft.network.packets.stc.TrafficSignWorkbenchUpdateClientPacket;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class TrafficSignPatternPacket
implements IPacketBase<TrafficSignPatternPacket> {
    private NamedTrafficSignTextureReference reference;
    private int index;

    public TrafficSignPatternPacket() {
    }

    public TrafficSignPatternPacket(NamedTrafficSignTextureReference reference, int index) {
        this.index = index;
        this.reference = reference;
    }

    public void encode(TrafficSignPatternPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.index);
        buffer.m_130079_(packet.reference.toNbt());
    }

    public TrafficSignPatternPacket decode(FriendlyByteBuf buffer) {
        int index = buffer.readInt();
        NamedTrafficSignTextureReference reference = NamedTrafficSignTextureReference.fromNbt(buffer.m_130260_());
        return new TrafficSignPatternPacket(reference, index);
    }

    public void handle(TrafficSignPatternPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            AbstractContainerMenu patt0$temp = sender.f_36096_;
            if (patt0$temp instanceof TrafficSignWorkbenchMenu) {
                TrafficSignWorkbenchMenu menu = (TrafficSignWorkbenchMenu)patt0$temp;
                ItemStack stack = menu.patternSlot.m_7993_();
                if (!(stack.m_41720_() instanceof PatternCatalogueItem)) {
                    return;
                }
                if (packet.index >= 0) {
                    PatternCatalogueItem.replacePattern(stack, packet.reference, packet.index);
                } else {
                    PatternCatalogueItem.setPattern(stack, packet.reference);
                }
                menu.patternSlot.m_5852_(stack);
                menu.patternSlot.m_6654_();
                menu.m_38946_();
                DLUtils.giveAdvancement((ServerPlayer)sender, (String)"trafficcraft", (String)"create_traffic_sign_pattern", (String)"requirement");
                TrafficCraft.net().sendToPlayer(sender, (Object)new TrafficSignWorkbenchUpdateClientPacket());
            }
        });
    }
}

