/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.trafficcraft.block.StreetLampBaseBlock;
import de.mrjulsen.trafficcraft.block.entity.StreetLampBlockEntity;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class StreetLampConfigCardItem
extends Item {
    private static final String NBT_TIME_ON = "turnOnTime";
    private static final String NBT_TIME_OFF = "turnOffTime";
    private static final String NBT_TIME_FORMAT = "timeFormat";
    private static final Component textEmpty = TextUtils.translate((String)"item.trafficcraft.street_lamp_config_card.tooltip.empty").m_130940_(ChatFormatting.GRAY);
    private static final Component textClear = TextUtils.translate((String)"item.trafficcraft.street_lamp_config_card.use.clear");
    private static final Component textErrorTimeEqual = TextUtils.translate((String)"item.trafficcraft.street_lamp_config_card.use.error_same_time").m_130940_(ChatFormatting.RED);
    private static final Component textApply = TextUtils.translate((String)"item.trafficcraft.street_lamp_config_card.use.set").m_130940_(ChatFormatting.GREEN);
    private static final Component textRemove = TextUtils.translate((String)"item.trafficcraft.street_lamp_config_card.use.unset").m_130940_(ChatFormatting.RED);
    private static final String keyTurnOn = "item.trafficcraft.street_lamp_config_card.tooltip.turn_on_time";
    private static final String keyTurnOff = "item.trafficcraft.street_lamp_config_card.tooltip.turn_off_time";

    public StreetLampConfigCardItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag nbt = null;
        if (player.m_6144_()) {
            nbt = StreetLampConfigCardItem.doesContainValidLinkData(stack);
            if (nbt != null) {
                nbt.m_128473_(NBT_TIME_ON);
                nbt.m_128473_(NBT_TIME_OFF);
            }
            player.m_5661_(textClear, true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (level.f_46443_) {
            int turnOn = 18500;
            int turnOff = 5500;
            int timeFormat = 0;
            nbt = StreetLampConfigCardItem.doesContainValidLinkData(stack);
            if (nbt != null) {
                turnOn = nbt.m_128451_(NBT_TIME_ON);
                turnOff = nbt.m_128451_(NBT_TIME_OFF);
            }
            timeFormat = stack.m_41784_().m_128451_(NBT_TIME_FORMAT);
            ClientWrapper.showStreetLampScheduleScreen(turnOn, turnOff, TimeUtils.TimeFormat.getFormatByIndex((byte)((byte)timeFormat)));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(ItemStack stack, Level player, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, player, list, flag);
        CompoundTag nbt = null;
        nbt = StreetLampConfigCardItem.doesContainValidLinkData(stack);
        if (nbt != null) {
            list.add((Component)TextUtils.translate((String)keyTurnOn, (Object[])new Object[]{TimeUtils.parseTime((long)nbt.m_128451_(NBT_TIME_ON), (TimeUtils.TimeFormat)TimeUtils.TimeFormat.getFormatByIndex((byte)((byte)nbt.m_128451_(NBT_TIME_FORMAT))))}));
            list.add((Component)TextUtils.translate((String)keyTurnOff, (Object[])new Object[]{TimeUtils.parseTime((long)nbt.m_128451_(NBT_TIME_OFF), (TimeUtils.TimeFormat)TimeUtils.TimeFormat.getFormatByIndex((byte)((byte)nbt.m_128451_(NBT_TIME_FORMAT))))}));
        } else {
            list.add(textEmpty);
        }
    }

    public boolean m_5812_(ItemStack pStack) {
        return StreetLampConfigCardItem.doesContainValidLinkData(pStack) != null || super.m_5812_(pStack);
    }

    public static CompoundTag doesContainValidLinkData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(NBT_TIME_ON) && tag.m_128441_(NBT_TIME_OFF) && tag.m_128441_(NBT_TIME_FORMAT) ? tag : null;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockEntity blockEntity;
        Level level = pContext.m_43725_();
        CompoundTag nbt = null;
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        BlockState state = pContext.m_43725_().m_8055_(pos);
        Player player = pContext.m_43723_();
        if (!player.m_6144_() && state.m_60734_() instanceof StreetLampBaseBlock && (blockEntity = level.m_7702_(pos)) instanceof StreetLampBlockEntity) {
            StreetLampBlockEntity blockEntity2 = (StreetLampBlockEntity)blockEntity;
            if (!level.f_46443_) {
                nbt = StreetLampConfigCardItem.doesContainValidLinkData(stack);
                if (nbt != null) {
                    if (nbt.m_128451_(NBT_TIME_ON) == nbt.m_128451_(NBT_TIME_OFF)) {
                        player.m_5661_(textErrorTimeEqual, false);
                        return InteractionResult.FAIL;
                    }
                    blockEntity2.setOnTime((int)TimeUtils.shiftDayTimeToMinecraftTicks((long)nbt.m_128451_(NBT_TIME_ON)));
                    blockEntity2.setOffTime((int)TimeUtils.shiftDayTimeToMinecraftTicks((long)nbt.m_128451_(NBT_TIME_OFF)));
                    player.m_5661_(textApply, true);
                    DLUtils.giveAdvancement((ServerPlayer)((ServerPlayer)player), (String)"trafficcraft", (String)"street_lamp_config", (String)"requirement");
                } else {
                    blockEntity2.setOnTime(-1);
                    blockEntity2.setOffTime(-1);
                    player.m_5661_(textRemove, true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(pContext);
    }
}

