/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.core.ColorObject;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ColorPaletteItem
extends Item {
    public static final int MAX_COLORS = 7;
    public static final String COLORS_TAG = "colors";

    public ColorPaletteItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, Level player, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, player, list, flag);
        if (!stack.m_41782_()) {
            list.add((Component)TextUtils.translate((String)"item.trafficcraft.color_palette.no_color").m_130940_(ChatFormatting.GRAY));
            return;
        }
        CompoundTag tag = ColorPaletteItem.checkNbt(stack);
        if (!IntStream.of(tag.m_128465_(COLORS_TAG)).anyMatch(x -> x != 0)) {
            list.add((Component)TextUtils.translate((String)"item.trafficcraft.color_palette.no_color").m_130940_(ChatFormatting.GRAY));
        } else {
            for (int i : tag.m_128465_(COLORS_TAG)) {
                if (i == 0) {
                    list.add((Component)TextUtils.translate((String)"item.trafficcraft.color_palette.color_unset").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                    continue;
                }
                ColorObject c = ColorObject.fromInt((int)i);
                list.add((Component)TextUtils.text((String)String.format("\u2b1b  %s, %s, %s (#%s)", c.getR(), c.getG(), c.getB(), Integer.toHexString(i).toUpperCase())).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)i))));
            }
        }
    }

    public static CompoundTag checkNbt(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_(COLORS_TAG)) {
            int[] c = new int[7];
            Arrays.fill(c, 0);
            nbt.m_128385_(COLORS_TAG, c);
        }
        return nbt;
    }

    public static int getColorAt(ItemStack stack, int index) {
        if (!stack.m_41782_()) {
            return 0;
        }
        if (index < 0 || index >= 7) {
            return 0;
        }
        return ColorPaletteItem.checkNbt(stack).m_128465_(COLORS_TAG)[index];
    }

    public static boolean setColor(ItemStack stack, int index, int color) {
        if (index < 0 || index >= 7) {
            return false;
        }
        int[] a = ColorPaletteItem.checkNbt(stack).m_128465_(COLORS_TAG);
        a[index] = color;
        ColorPaletteItem.checkNbt(stack).m_128385_(COLORS_TAG, a);
        return true;
    }
}

