/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.data;

import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureManager;
import dev.architectury.utils.GameInstance;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class TrafficSignTextureData {
    private static final String NBT_VERSION = "Version";
    private static final String NBT_HASH = "Hash";
    private static final String NBT_PIXEL_DATA = "Data";
    private static final String NBT_WIDTH = "Width";
    private static final String NBT_HEIGHT = "Height";
    private static final String NBT_CREATION_TIME = "CreationTime";
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_USES = "Uses";
    private static final String NBT_LAST_ACCESS_TIME = "LastAccessTime";
    private static final String NBT_SHAPE = "Shape";
    public static final int VERSION = 1;
    private final int version;
    private final UUID hash;
    private final byte[] pixelData;
    private final short width;
    private final short height;
    private final long creationTime;
    private final UUID owner;
    private final TrafficSignShape shape;
    private int uses;
    private long lastAccessTime;
    private boolean hasErrors = false;

    public TrafficSignTextureData(TrafficSignShape shape, byte[] pixelData, short width, short height, long creationTime, UUID owner) {
        this(1, shape, pixelData, width, height, creationTime, owner);
    }

    private TrafficSignTextureData(int version, TrafficSignShape shape, byte[] pixelData, short width, short height, long creationTime, UUID owner) {
        this.version = version;
        this.shape = shape;
        this.pixelData = pixelData;
        this.width = width;
        this.height = height;
        this.creationTime = creationTime;
        this.owner = owner;
        this.hash = this.calculateHash();
    }

    public static TrafficSignTextureData empty() {
        return new TrafficSignTextureData(TrafficSignShape.SQUARE, new byte[0], 1, 1, System.currentTimeMillis(), new UUID(0L, 0L));
    }

    public UUID calculateHash() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA3-512");
            byte[] hash = md.digest(this.pixelData);
            ByteBuffer byteBuffer = ByteBuffer.wrap(hash);
            long high = byteBuffer.getLong();
            long low = byteBuffer.getLong();
            UUID id = new UUID(high, low);
            return id;
        }
        catch (Exception e) {
            TrafficCraft.LOGGER.error("Unable to calculate texture hash value.", (Throwable)e);
            return new UUID(0L, 0L);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public UUID getHash() {
        return this.hash;
    }

    public byte[] getPixelData() {
        return this.pixelData;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public int getUses() {
        return this.uses;
    }

    public void setUses(int uses) {
        this.uses = uses;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastLoadedTime) {
        this.lastAccessTime = lastLoadedTime;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public TrafficSignShape getShape() {
        return this.shape;
    }

    public synchronized void save() {
        if (this.hasErrors()) {
            return;
        }
        try {
            File file = new File(GameInstance.getServer().m_129843_(TrafficSignTextureManager.getResource(this.getHash().toString())).toString());
            file.getParentFile().mkdirs();
            NbtIo.m_128944_((CompoundTag)this.serializeNbt(), (File)file);
        }
        catch (IOException e) {
            TrafficCraft.LOGGER.error("Unable to save traffic sign texture file.", (Throwable)e);
        }
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_VERSION, 1);
        nbt.m_128362_(NBT_HASH, this.hash);
        nbt.m_128405_(NBT_SHAPE, this.shape.getIndex());
        nbt.m_128382_(NBT_PIXEL_DATA, this.pixelData);
        nbt.m_128376_(NBT_WIDTH, this.width);
        nbt.m_128376_(NBT_HEIGHT, this.height);
        nbt.m_128356_(NBT_CREATION_TIME, this.creationTime);
        nbt.m_128362_(NBT_OWNER, this.owner);
        nbt.m_128405_(NBT_USES, this.uses);
        nbt.m_128356_(NBT_LAST_ACCESS_TIME, this.lastAccessTime);
        return nbt;
    }

    public static TrafficSignTextureData deserializeNbt(CompoundTag nbt) {
        UUID oldHash;
        TrafficSignTextureData data = new TrafficSignTextureData(nbt.m_128451_(NBT_VERSION), TrafficSignShape.getShapeByIndex(nbt.m_128451_(NBT_SHAPE)), nbt.m_128463_(NBT_PIXEL_DATA), nbt.m_128448_(NBT_WIDTH), nbt.m_128448_(NBT_HEIGHT), nbt.m_128454_(NBT_CREATION_TIME), nbt.m_128342_(NBT_OWNER));
        data.uses = nbt.m_128451_(NBT_USES);
        data.lastAccessTime = nbt.m_128454_(NBT_LAST_ACCESS_TIME);
        UUID newHash = data.getHash();
        if (!newHash.equals(oldHash = nbt.m_128342_(NBT_HASH))) {
            TrafficCraft.LOGGER.warn("The Hash value of this traffic sign texture has been changed! Is " + String.valueOf(newHash) + ", was " + String.valueOf(oldHash) + ".");
            data.hasErrors = true;
        }
        return data;
    }
}

