/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.data;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.compat.TrafficLightMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class TrafficLightScheduleEntryData
implements INBTSerializable {
    private static final String NBT_ID = "id";
    private static final String NBT_TICKS = "ticks";
    private static final String NBT_COLOR = "color";
    @Deprecated
    private static final String NBT_MODE = "mode";
    public static final int MAX_SECONDS = 999;
    public static final int MAX_TICKS = 19980;
    private List<TrafficLightColor> enabledColors = new ArrayList<TrafficLightColor>(TrafficLightColor.values().length);
    private int ticks = 0;
    private int id = 0;

    public TrafficLightScheduleEntryData copy() {
        TrafficLightScheduleEntryData data = new TrafficLightScheduleEntryData();
        data.enabledColors = new ArrayList<TrafficLightColor>(this.enabledColors);
        data.ticks = this.ticks;
        data.id = this.id;
        return data;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrafficLightScheduleEntryData) {
            TrafficLightScheduleEntryData other = (TrafficLightScheduleEntryData)obj;
            return this.ticks == other.ticks && this.id == other.id && this.enabledColors.size() == other.enabledColors.size() && this.enabledColors.stream().allMatch(x -> other.enabledColors.stream().anyMatch(y -> x == y));
        }
        return false;
    }

    public int getDurationTicks() {
        return this.ticks;
    }

    public double getDurationSeconds() {
        return (double)this.ticks / DragonLib.tps();
    }

    public int getPhaseId() {
        return this.id;
    }

    public List<TrafficLightColor> getEnabledColors() {
        return this.enabledColors;
    }

    public void enableColors(Collection<TrafficLightColor> colors) {
        this.enabledColors.addAll(colors);
        this.enabledColors.stream().distinct().toList();
    }

    public void enableOnlyColors(Collection<TrafficLightColor> colors) {
        this.enabledColors.clear();
        this.enabledColors.addAll(colors);
        this.enabledColors.stream().distinct().toList();
    }

    public void disableColors(Collection<TrafficLightColor> colors) {
        colors.forEach(x -> this.enabledColors.removeIf(y -> x == y));
    }

    public void disableAll(Collection<TrafficLightColor> colors) {
        this.enabledColors.clear();
    }

    public void setDurationTicks(int ticks) {
        this.ticks = Mth.m_14045_((int)ticks, (int)0, (int)19980);
    }

    public void setDurationSeconds(double seconds) {
        this.setDurationTicks((int)(seconds * 20.0));
    }

    public void addDurationTicks(int amount) {
        this.ticks = Math.min(this.ticks + amount, 19980);
    }

    public void addDurationSeconds(int amount) {
        this.addDurationTicks(amount * 20);
    }

    public void subDurationTicks(int amount) {
        this.ticks = Math.max(this.ticks - amount, 0);
    }

    public void subDurationSeconds(int amount) {
        this.subDurationTicks(amount * 20);
    }

    public void setPhaseId(int id) {
        this.id = id;
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(NBT_ID, this.getPhaseId());
        tag.m_128405_(NBT_TICKS, this.getDurationTicks());
        tag.m_128385_(NBT_COLOR, this.getEnabledColors().stream().mapToInt(x -> x.getIndex()).toArray());
        return tag;
    }

    public void fromNbt(CompoundTag tag) {
        this.id = tag.m_128451_(NBT_ID);
        this.ticks = tag.m_128451_(NBT_TICKS);
        int[] bArr = tag.m_128465_(NBT_COLOR);
        ArrayList<TrafficLightColor> colors = new ArrayList<TrafficLightColor>(bArr.length);
        for (int i = 0; i < bArr.length; ++i) {
            colors.add(TrafficLightColor.getColorByIndex((byte)bArr[i]));
        }
        this.enabledColors = colors;
        this.migrateData(tag);
    }

    private void migrateData(CompoundTag nbt) {
        if (this.shouldMigrate(nbt)) {
            this.enableOnlyColors(TrafficLightMode.getModeByIndex(nbt.m_128451_(NBT_MODE)).convertToColorList());
        }
    }

    public double migrateTime(TrafficLightScheduleEntryData last) {
        double lastTime = last.getDurationSeconds();
        last.setDurationSeconds(this.getDurationSeconds());
        return lastTime;
    }

    public boolean shouldMigrate(CompoundTag nbt) {
        return nbt.m_128441_(NBT_MODE);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.ticks);
        TrafficLightColor[] cArr = (TrafficLightColor[])this.getEnabledColors().toArray(TrafficLightColor[]::new);
        byte[] bArr = new byte[cArr.length];
        for (int i = 0; i < bArr.length; ++i) {
            bArr[i] = cArr[i].getIndex();
        }
        buf.m_130087_(bArr);
    }

    public static TrafficLightScheduleEntryData fromBytes(FriendlyByteBuf buf) {
        TrafficLightScheduleEntryData data = new TrafficLightScheduleEntryData();
        data.setPhaseId(buf.readInt());
        data.setDurationTicks(buf.readInt());
        byte[] bArr = buf.m_130052_();
        ArrayList<TrafficLightColor> colors = new ArrayList<TrafficLightColor>(bArr.length);
        for (int i = 0; i < bArr.length; ++i) {
            colors.add(TrafficLightColor.getColorByIndex(bArr[i]));
        }
        data.enableOnlyColors(colors);
        return data;
    }

    public CompoundTag serializeNbt() {
        return this.toNbt();
    }

    public void deserializeNbt(CompoundTag nbt) {
        this.fromNbt(nbt);
    }
}

