/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.tooltip;

import com.mojang.blaze3d.vertex.PoseStack;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.DataCache;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.client.tooltip.TrafficSignTooltip;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.FormattedText;

public class ClientTrafficSignTooltipStack
implements ClientTooltipComponent {
    private final NonNullList<NamedTrafficSignTextureReference> patterns;
    private final NamedTrafficSignTextureReference selectedData;
    private final Map<NamedTrafficSignTextureReference, TrafficSignClientTexture> textures;
    private static final float FONT_SCALE = 0.75f;
    private int lastKnownTexturesCount = 0;
    private final DataCache<Pair<Integer, Integer>, Integer> gridLayout = new DataCache(n -> {
        if (n <= 0) {
            return Pair.of((Object)1, (Object)n);
        }
        int sqrt = (int)Math.sqrt(n.doubleValue());
        int width = (int)Math.ceil((double)n.intValue() / (double)sqrt);
        return Pair.of((Object)width, (Object)sqrt);
    });

    public ClientTrafficSignTooltipStack(TrafficSignTooltip pTrafficSignTooltip) {
        this.patterns = pTrafficSignTooltip.getPatterns();
        this.selectedData = pTrafficSignTooltip.getSelected();
        this.textures = pTrafficSignTooltip.getTextures();
    }

    public int m_142103_() {
        int n;
        this.checkGridLayout();
        int n2 = (Integer)((Pair)this.gridLayout.get((Object)this.lastKnownTexturesCount)).getSecond() * 18;
        if (this.selectedData == null) {
            n = 0;
        } else {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            n = 9 * 2 + 24;
        }
        return n2 + n;
    }

    public int m_142069_(Font pFont) {
        this.checkGridLayout();
        return (Integer)((Pair)this.gridLayout.get((Object)this.lastKnownTexturesCount)).getFirst() * 18;
    }

    private void checkGridLayout() {
        if (this.lastKnownTexturesCount != this.patterns.size()) {
            this.lastKnownTexturesCount = this.patterns.size();
            this.gridLayout.clear();
        }
    }

    public void m_183452_(Font pFont, int pX, int pY, GuiGraphics guiGraphics) {
        this.checkGridLayout();
        Graphics graphics = new Graphics(guiGraphics, guiGraphics.m_280168_());
        Pair grid = (Pair)this.gridLayout.get((Object)this.lastKnownTexturesCount);
        int x = pX;
        int y = pY;
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        graphics.poseStack().m_252880_(0.0f, 0.0f, 1000.0f);
        if (this.selectedData != null) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_252880_((float)(x + 5) / 0.75f, (float)y / 0.75f, 0.0f);
            GuiUtils.drawString((Graphics)graphics, (Font)pFont, (int)0, (int)0, (FormattedText)TextUtils.translate((String)"item.trafficcraft.pattern_catalogue.tooltip.selected_texture"), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            Objects.requireNonNull(pFont);
            GuiUtils.drawString((Graphics)graphics, (Font)pFont, (int)32, (int)(9 + 10), (String)this.selectedData.getName(), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().m_85849_();
        }
        if (this.lastKnownTexturesCount > 0) {
            graphics.poseStack().m_85836_();
            PoseStack poseStack = graphics.poseStack();
            float f = (float)(x + 5) / 0.75f;
            Objects.requireNonNull(pFont);
            poseStack.m_252880_(f, (float)(y + 9 + 24) / 0.75f, 0.0f);
            GuiUtils.drawString((Graphics)graphics, (Font)pFont, (int)0, (int)0, (FormattedText)TextUtils.translate((String)"item.trafficcraft.pattern_catalogue.tooltip.saved_textures"), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().m_85849_();
        }
        graphics.poseStack().m_85849_();
        if (this.selectedData != null) {
            Objects.requireNonNull(pFont);
            this.renderTexture(guiGraphics, x + 10, y + 9, this.selectedData);
        }
        Objects.requireNonNull(pFont);
        y += 9 * 2 + 24;
        int k = 0;
        for (int i = 0; i < (Integer)grid.getFirst() && k < this.lastKnownTexturesCount; ++i) {
            for (int j = 0; j < (Integer)grid.getSecond() && k < this.lastKnownTexturesCount; ++j) {
                int n = k++;
                NamedTrafficSignTextureReference textureData = (NamedTrafficSignTextureReference)this.patterns.get(n);
                this.renderTexture(guiGraphics, x + 10 + i * 18, y + j * 18, textureData);
            }
        }
    }

    private void renderTexture(GuiGraphics guiGraphics, int x, int y, NamedTrafficSignTextureReference data) {
        TrafficSignClientTexture texture = this.textures.get(data);
        if (texture != null) {
            int w = texture.getRawData().getWidth();
            int h = texture.getRawData().getHeight();
            guiGraphics.m_280411_(texture.getTextureLocation(), x, y, 16, 16, 0.0f, 0.0f, w, h, w, h);
        }
    }
}

