/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.ber;

import com.mojang.math.Axis;
import de.mrjulsen.mcdragonlib.block.WritableSignBlockEntity;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.SafeBlockEntityRenderer;
import de.mrjulsen.mcdragonlib.client.builtin.WritableSignScreen;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class WritableSignBlockEntityRenderer<T extends WritableSignBlockEntity>
extends SafeBlockEntityRenderer<T> {
    protected final Font font;

    public WritableSignBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.font = context.m_173586_();
    }

    public void renderSafe(BERGraphics<T> graphics, float pPartialTick) {
        WritableSignScreen.WritableSignConfig config = ((WritableSignBlockEntity)graphics.blockEntity()).getRenderConfig();
        this.renderInternal(config, arg_0 -> ((WritableSignBlockEntity)((WritableSignBlockEntity)graphics.blockEntity())).getText(arg_0), pPartialTick, graphics, false);
        if (config.renderBack()) {
            this.renderInternal(config, arg_0 -> ((WritableSignBlockEntity)((WritableSignBlockEntity)graphics.blockEntity())).getText(arg_0), pPartialTick, graphics, true);
        }
    }

    protected void renderInternal(WritableSignScreen.WritableSignConfig config, Function<Integer, String> getText, float pPartialTick, BERGraphics<T> graphics, boolean isOpposite) {
        BlockState blockState = ((WritableSignBlockEntity)graphics.blockEntity()).m_58900_();
        float scale = 1.0f / config.scale();
        for (int lineIndex = 0; lineIndex < config.lineData().length; ++lineIndex) {
            String line = getText.apply(lineIndex);
            if (line == null || this.font.m_92895_(line) == 0) continue;
            WritableSignScreen.ConfiguredLineData data = config.lineData()[lineIndex];
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85837_(0.5, 0.5, 0.5);
            graphics.poseStack().m_252781_(Axis.f_252436_.m_252977_(((Float)config.blockEntityRendererRotation().apply(blockState)).floatValue() + (float)(isOpposite ? 180 : 0)));
            graphics.poseStack().m_252880_((float)(isOpposite ? -1 : 1) * config.berX(), config.berY(), config.berZ());
            float xCenter = -this.font.m_92895_(line) / 2;
            Vector3f vector3f = config.berTextScale(line, this.font, scale, data);
            graphics.poseStack().m_85841_(scale, -scale, scale);
            graphics.poseStack().m_252880_(data.xOffset() / scale, data.yOffset() / scale - 5.0f * config.lineData()[0].lineHeightScale() + (float)config.getLineHeightsUntil(lineIndex) + (float)config.getLineOffset(lineIndex, vector3f.y()), 0.0f);
            graphics.poseStack().m_85841_(vector3f.x(), vector3f.y(), vector3f.z());
            BERUtils.drawString(graphics, (Font)this.font, (float)xCenter, (float)0.0f, (String)line, (int)config.berColor(), (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().m_85849_();
        }
    }
}

