/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.TrafficSignBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureData;
import de.mrjulsen.trafficcraft.network.packets.stc.TrafficSignTextureResetPacket;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import dev.architectury.utils.GameInstance;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrafficSignBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_LEGACY_TEXTURE = "texture";
    private static final String NBT_TEXTURE = "SignTexture";
    private String textureId;
    private TrafficSignClientTexture texture;

    protected TrafficSignBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TrafficSignBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRAFFIC_SIGN_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_(NBT_LEGACY_TEXTURE)) {
            this.migrate(compound.m_128461_(NBT_LEGACY_TEXTURE));
        } else if (compound.m_128441_(NBT_TEXTURE)) {
            this.setTextureId(compound.m_128461_(NBT_TEXTURE));
        }
    }

    private void migrate(String base64) {
        new Thread(() -> {
            while (this.m_58904_() == null) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.m_58904_().f_46443_) {
                return;
            }
            GameInstance.getServer().execute(() -> {
                BlockState state = this.m_58904_().m_8055_(this.m_58899_());
                TrafficSignTextureData data = new TrafficSignTextureData((TrafficSignShape)((Object)((Object)((Object)state.m_61143_(TrafficSignBlock.SHAPE)))), Base64.getDecoder().decode(base64), 32, 32, System.currentTimeMillis(), new UUID(0L, 0L));
                data.save();
                this.setTextureId(data.getHash().toString());
            });
        }, "Traffic Sign Migration").start();
    }

    protected void m_183515_(CompoundTag tag) {
        if (this.textureId != null) {
            tag.m_128359_(NBT_TEXTURE, this.getTextureId());
        }
        super.m_183515_(tag);
    }

    public void m_7651_() {
        super.m_7651_();
        this.resetTexture();
    }

    public String getTextureId() {
        return this.textureId;
    }

    public TrafficSignClientTexture getClientTexture() {
        if (this.texture == null) {
            if (this.getTextureId() == null || this.getTextureId().equals("empty")) {
                return TrafficSignClientTexture.EMPTY;
            }
            this.texture = TrafficSignClientTexture.load(this.getTextureId(), true);
        }
        return this.texture;
    }

    public void resetTexture() {
        if (this.f_58857_.f_46443_) {
            DLUtils.doIfNotNull((Object)this.texture, x -> x.close());
            this.texture = null;
        }
    }

    public void setAndResetTexture(NamedTrafficSignTextureReference texture) {
        this.setTextureId(texture.getTextureId());
        if (!this.f_58857_.f_46443_) {
            for (ServerPlayer player : (ServerPlayer[])this.f_58857_.m_6907_().stream().filter(p -> p instanceof ServerPlayer).toArray(ServerPlayer[]::new)) {
                TrafficCraft.net().sendToPlayer(player, (Object)new TrafficSignTextureResetPacket(this.m_58899_()));
            }
        }
    }

    public void setTextureId(String id) {
        this.textureId = id;
        this.notifyUpdate();
    }
}

