/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.trafficcraft.block.TrafficLightRequestButtonBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficLightTrigger;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TrafficLightRequestButtonBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_LISTENING = "listening";
    private static final String NBT_LINKED_TO = "linkedTo";
    private Location linkLocation;
    private boolean listening;

    protected TrafficLightRequestButtonBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TrafficLightRequestButtonBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRAFFIC_LIGHT_REQUEST_BUTTON_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.listening = compound.m_128471_(NBT_LISTENING);
        if (compound.m_128441_(NBT_LINKED_TO)) {
            this.linkLocation = Location.fromNbt((CompoundTag)compound.m_128469_(NBT_LINKED_TO));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128379_(NBT_LISTENING, this.listening);
        if (this.linkLocation != null) {
            tag.m_128365_(NBT_LINKED_TO, (Tag)this.linkLocation.toNbt());
        }
        super.m_183515_(tag);
    }

    private void tick(Level level, BlockPos pos, BlockState state) {
        if (this.listening && !level.f_46443_) {
            boolean isRunning = false;
            if (this.linkLocation != null) {
                BlockEntity blockEntity = level.m_7702_(this.linkLocation.getLocationBlockPos());
                if (blockEntity instanceof TrafficLightBlockEntity) {
                    TrafficLightBlockEntity blockEntity2 = (TrafficLightBlockEntity)blockEntity;
                    isRunning = blockEntity2.isFirstIteration();
                } else {
                    blockEntity = level.m_7702_(this.linkLocation.getLocationBlockPos());
                    if (blockEntity instanceof TrafficLightControllerBlockEntity) {
                        TrafficLightControllerBlockEntity blockEntity3 = (TrafficLightControllerBlockEntity)blockEntity;
                        isRunning = blockEntity3.isFirstIteration();
                    }
                }
            }
            if (!isRunning) {
                this.listening = false;
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)TrafficLightRequestButtonBlock.ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TrafficLightRequestButtonBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TrafficLightRequestButtonBlockEntity blockEntity) {
        blockEntity.tick(level, pos, state);
    }

    public void linkTo(Location loc) {
        this.linkLocation = loc;
        this.notifyUpdate();
    }

    public void clearLink() {
        this.linkLocation = null;
        this.notifyUpdate();
    }

    public Location getLinkLocation() {
        return this.linkLocation;
    }

    public boolean isValidLinked() {
        return this.getLinkLocation() != null && (this.f_58857_.m_7702_(this.linkLocation.getLocationBlockPos()) instanceof TrafficLightControllerBlockEntity || this.f_58857_.m_7702_(this.linkLocation.getLocationBlockPos()) instanceof TrafficLightBlockEntity);
    }

    public boolean isListening() {
        return this.listening;
    }

    public boolean activate() {
        if (!this.isValidLinked()) {
            return false;
        }
        this.listening = true;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.linkLocation.getLocationBlockPos());
        if (blockEntity instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity2 = (TrafficLightBlockEntity)blockEntity;
            if (blockEntity2.getSchedule().getTrigger() == TrafficLightTrigger.ON_REQUEST) {
                blockEntity2.startSchedule(true);
                return true;
            }
        } else {
            TrafficLightControllerBlockEntity blockEntity3;
            blockEntity = this.f_58857_.m_7702_(this.linkLocation.getLocationBlockPos());
            if (blockEntity instanceof TrafficLightControllerBlockEntity && (blockEntity3 = (TrafficLightControllerBlockEntity)blockEntity).getFirstOrMainSchedule().getTrigger() == TrafficLightTrigger.ON_REQUEST) {
                blockEntity3.startSchedule(true);
                return true;
            }
        }
        this.listening = false;
        return false;
    }
}

