/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.data;

import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.trafficcraft.block.data.TrafficLightType;
import java.util.Arrays;
import net.minecraft.util.StringRepresentable;

public enum TrafficLightColor implements StringRepresentable,
ITranslatableEnum
{
    NONE("none", 0, TrafficLightType.values(), 0),
    RED("red", 1, new TrafficLightType[]{TrafficLightType.CAR}, 1),
    YELLOW("yellow", 2, new TrafficLightType[]{TrafficLightType.CAR}, 2),
    GREEN("green", 3, new TrafficLightType[]{TrafficLightType.CAR}, 3),
    F0("f0", 4, new TrafficLightType[]{TrafficLightType.TRAM}, 1),
    F4("f4", 5, new TrafficLightType[]{TrafficLightType.TRAM}, 2),
    F1_F2_F3_F5("f1_f2_f3_f5", 6, new TrafficLightType[]{TrafficLightType.TRAM}, 3);

    private String name;
    private byte index;
    private TrafficLightType[] allowedInTypes;
    private byte groupIndex;

    private TrafficLightColor(String name, int index, TrafficLightType[] allowedInTypes, int groupIndex) {
        this.name = name;
        this.index = (byte)index;
        this.allowedInTypes = allowedInTypes;
        this.groupIndex = (byte)groupIndex;
    }

    public String getName() {
        return this.name;
    }

    public byte getIndex() {
        return this.index;
    }

    public static TrafficLightColor[] getAllowedForType(TrafficLightType type, boolean offStatusAllowed) {
        return (TrafficLightColor[])Arrays.stream(TrafficLightColor.values()).filter(x -> Arrays.stream(x.allowedInTypes).anyMatch(y -> y == type) && (offStatusAllowed || x != NONE)).toArray(TrafficLightColor[]::new);
    }

    public boolean isAllowedFor(TrafficLightType type) {
        return Arrays.stream(this.allowedInTypes).anyMatch(x -> x == type);
    }

    public byte getGroupIndex() {
        return this.groupIndex;
    }

    public TrafficLightColor[] getSimilar() {
        return (TrafficLightColor[])Arrays.stream(TrafficLightColor.values()).filter(x -> x.getGroupIndex() == this.getGroupIndex()).toArray(TrafficLightColor[]::new);
    }

    public boolean isSimilar(TrafficLightColor other) {
        return this.getGroupIndex() == other.getGroupIndex();
    }

    public String getTranslationKey() {
        return String.format("gui.trafficcraft.trafficlightcolor.%s", this.name);
    }

    public static TrafficLightColor getColorByIndex(byte index) {
        return Arrays.stream(TrafficLightColor.values()).filter(x -> x.getIndex() == index).findFirst().orElse(NONE);
    }

    public static TrafficLightColor getColorByGroupIndex(byte index, TrafficLightType type) {
        return Arrays.stream(TrafficLightColor.values()).filter(x -> x.getGroupIndex() == index && x.isAllowedFor(type)).findFirst().orElse(NONE);
    }

    public String m_7912_() {
        return this.name;
    }

    public String getEnumName() {
        return "trafficlightcolor";
    }

    public String getEnumValueName() {
        return this.getName();
    }
}

