/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.data;

import de.mrjulsen.trafficcraft.block.PaintedAsphaltBlock;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.ColorableBlock;
import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class RoadBlock
extends ColorableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private RoadType defaultRoadType;

    public RoadBlock(BlockBehaviour.Properties properties, RoadType type) {
        super(properties);
        this.defaultRoadType = type;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RoadType getDefaultRoadType() {
        return this.defaultRoadType;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING});
    }

    @Override
    public InteractionResult onSetColor(UseOnContext pContext) {
        Object id = "";
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        BlockState state = level.m_8055_(pos);
        ItemStack stack = pContext.m_43722_();
        Player player = pContext.m_43723_();
        if (level.m_7702_(pos) instanceof IColorBlockEntity) {
            if (state.m_60734_() instanceof PaintedAsphaltBlock) {
                id = this.getDefaultRoadType().getRoadType() + "_pattern_" + BrushItem.getPatternId(stack);
            } else if (state.m_60734_() instanceof PaintedAsphaltSlope) {
                id = this.getDefaultRoadType().getRoadType() + "_slope_pattern_" + BrushItem.getPatternId(stack);
            }
            if (!ModBlocks.ROAD_BLOCKS.containsKey(id)) {
                return InteractionResult.FAIL;
            }
            BlockState newState = (BlockState)((Block)ModBlocks.ROAD_BLOCKS.get(id).get()).m_49966_().m_61124_((Property)FACING, (Comparable)player.m_6350_());
            if (state.m_60734_() instanceof PaintedAsphaltSlope) {
                newState = (BlockState)newState.m_61124_((Property)PaintedAsphaltSlope.LAYERS, (Comparable)((Integer)state.m_61143_((Property)PaintedAsphaltSlope.LAYERS)));
            }
            level.m_46597_(pos, newState);
            super.onSetColor(pContext);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public InteractionResult update(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        BlockState state = level.m_8055_(pos);
        ItemStack stack = pContext.m_43722_();
        Object id = "";
        if (state.m_60734_() instanceof PaintedAsphaltBlock) {
            id = this.getDefaultRoadType().getRoadType() + "_pattern_" + BrushItem.getPatternId(stack);
        } else if (state.m_60734_() instanceof PaintedAsphaltSlope) {
            id = this.getDefaultRoadType().getRoadType() + "_slope_pattern_" + BrushItem.getPatternId(stack);
        }
        if (ModBlocks.ROAD_BLOCKS.containsKey(id) && state.m_60734_() != ModBlocks.ROAD_BLOCKS.get(id).get()) {
            return this.onSetColor(pContext);
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_175362_(Direction.Axis.Y)));
        level.m_5594_(null, pos, SoundEvents.f_12392_, SoundSource.BLOCKS, 0.8f, 2.0f);
        return InteractionResult.SUCCESS;
    }
}

