/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.mcdragonlib.core.IIterableEnum;
import de.mrjulsen.trafficcraft.block.entity.EmptyBlockEntity;
import de.mrjulsen.trafficcraft.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoadSaltBlock
extends BaseEntityBlock {
    public static final EnumProperty<RoadSaltQuality> QUALITY = EnumProperty.m_61587_((String)"quality", RoadSaltQuality.class);

    public RoadSaltBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_60910_().m_60966_().m_278166_(PushReaction.DESTROY).m_222994_().m_60918_(SoundType.f_56739_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(QUALITY, (Comparable)((Object)RoadSaltQuality.FRESH)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{QUALITY});
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == Direction.DOWN && !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : pState;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        return this.canSurviveOn((BlockGetter)level, blockpos, blockstate);
    }

    private boolean canSurviveOn(BlockGetter reader, BlockPos pos, BlockState state) {
        return state.m_60783_(reader, pos, Direction.UP);
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return true;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return true;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new EmptyBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.f_46443_) {
            return (level, pos, state, blockEntity) -> {
                int randTicks = ((GameRules.IntegerValue)level.m_46469_().m_46170_(GameRules.f_46143_)).m_46288_();
                if (randTicks <= 0 || level.m_213780_().m_188503_((Integer)ModCommonConfig.ROAD_SALT_SPEED.get() * 3 * (((RoadSaltQuality)((Object)((Object)pState.m_61143_(QUALITY)))).getIndex() + 1) / randTicks) != 0) {
                    return;
                }
                ArrayList blocks = new ArrayList();
                BlockPos.m_121940_((BlockPos)pos.m_7918_(-((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue(), -((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue(), -((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue()), (BlockPos)pos.m_7918_(((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue(), 1, ((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue())).iterator().forEachRemaining(a -> blocks.add(new BlockPos((Vec3i)a)));
                Collections.shuffle(blocks);
                Iterator iterator = blocks.iterator();
                do {
                    BlockPos blockpos;
                    if ((blockpos = (BlockPos)iterator.next()).m_123333_((Vec3i)pos) > (Integer)ModCommonConfig.ROAD_SALT_RANGE.get()) continue;
                    if (level.m_8055_(blockpos).m_60713_(Blocks.f_50125_) || level.m_8055_(blockpos).m_60713_(Blocks.f_50126_)) {
                        Block.m_49950_((BlockState)state, (Level)level, (BlockPos)blockpos);
                        level.m_7471_(blockpos, false);
                        if ((Integer)ModCommonConfig.ROAD_SALT_PRESERVATION.get() >= 0 && level.m_213780_().m_188503_((Integer)ModCommonConfig.ROAD_SALT_PRESERVATION.get() * (((RoadSaltQuality)((Object)((Object)pState.m_61143_(QUALITY)))).getIndex() + 1)) == 0) {
                            RoadSaltQuality quality = (RoadSaltQuality)((RoadSaltQuality)((Object)((Object)level.m_8055_(pos).m_61143_(QUALITY)))).next();
                            if (quality.getIndex() == 0) {
                                level.m_7471_(pos, false);
                            } else {
                                level.m_46597_(pos, (BlockState)pState.m_61124_(QUALITY, (Comparable)((Object)quality)));
                            }
                        }
                        return;
                    }
                    if (!((Boolean)ModCommonConfig.ROAD_SALT_DAMAGE.get()).booleanValue()) continue;
                    if (level.m_8055_(blockpos).m_204336_(BlockTags.f_144274_) && !level.m_8055_(blockpos).m_60713_(Blocks.f_50546_)) {
                        level.m_46597_(blockpos, Blocks.f_50546_.m_49966_());
                        return;
                    }
                    if (level.m_8055_(blockpos).m_204336_(BlockTags.f_13037_) || level.m_8055_(blockpos).m_204336_(BlockTags.f_13073_)) {
                        level.m_7471_(blockpos, false);
                        return;
                    }
                    if (level.m_8055_(blockpos).m_60713_(Blocks.f_50036_) || !level.m_8055_(blockpos).m_204336_(BlockTags.f_13104_)) continue;
                    level.m_46597_(blockpos, Blocks.f_50036_.m_49966_());
                    return;
                } while (iterator.hasNext());
            };
        }
        return null;
    }

    public static enum RoadSaltQuality implements StringRepresentable,
    IIterableEnum<RoadSaltQuality>
    {
        FRESH(0, "fresh"),
        MUDDY(1, "muddy"),
        DILUTED(2, "diluted");

        private final int index;
        private final String name;

        private RoadSaltQuality(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public RoadSaltQuality[] getValues() {
            return RoadSaltQuality.values();
        }
    }
}

