/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.AsphaltBlock;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AsphaltSlope
extends AsphaltBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_HEIGHT = 8;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public static final int HEIGHT_IMPASSABLE = 5;

    public AsphaltSlope(RoadType type) {
        super(type);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        switch (pType) {
            case LAND: {
                return (Integer)pState.m_61143_((Property)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack tool) {
        if (!tool.m_150930_((Item)ModItems.HAMMER.get())) {
            super.m_6240_(level, player, pos, state, blockEntity, tool);
            return;
        }
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        player.m_36399_(0.005f);
        if (level.f_46443_) {
            level.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)state));
        } else {
            if (!player.m_7500_() && !player.m_5833_()) {
                AsphaltSlope.m_49950_((BlockState)state.m_60734_().m_49966_(), (Level)level, (BlockPos)pos.m_7918_(0, (int)(0.125f * (float)((Integer)state.m_61143_((Property)BlockStateProperties.f_61417_) + 1)), 0));
            }
            tool.m_41622_(1, (LivingEntity)player, p -> player.m_21166_(player.m_21120_(InteractionHand.MAIN_HAND) == tool ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
        }
        if ((Integer)state.m_61143_((Property)BlockStateProperties.f_61417_) <= 1) {
            return;
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)BlockStateProperties.f_61417_) - 1)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        int i = (Integer)pState.m_61143_((Property)LAYERS);
        Item item = pUseContext.m_43722_().m_41720_();
        if (item instanceof BlockItem) {
            Block block;
            BlockItem blockitem = (BlockItem)item;
            if (i < 8 && (block = blockitem.m_40614_()) instanceof AsphaltSlope) {
                AsphaltSlope selectedSlope = (AsphaltSlope)block;
                block = pState.m_60734_();
                if (block instanceof AsphaltSlope) {
                    AsphaltSlope targetSlope = (AsphaltSlope)block;
                    if (selectedSlope.getDefaultRoadType() == targetSlope.getDefaultRoadType()) {
                        if (pUseContext.m_7058_()) {
                            return pUseContext.m_43719_() == Direction.UP;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        boolean flag;
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean bl = flag = fluidstate.m_76152_() == Fluids.f_76193_;
        if (blockstate.m_60734_() instanceof PaintedAsphaltSlope || blockstate.m_60734_() instanceof AsphaltSlope) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)((BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LAYERS, WATERLOGGED});
        super.m_7926_(pBuilder);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }
}

