/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedFloatingLongValue;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public enum InductionProviderTier implements ITier
{
    BASIC(BaseTier.BASIC, FloatingLong.createConst(256000L)),
    ADVANCED(BaseTier.ADVANCED, FloatingLong.createConst(2048000L)),
    ELITE(BaseTier.ELITE, FloatingLong.createConst(0xFA0000L)),
    ULTIMATE(BaseTier.ULTIMATE, FloatingLong.createConst(0x7D00000L));

    private final FloatingLong baseOutput;
    private final BaseTier baseTier;
    @Nullable
    private CachedFloatingLongValue outputReference;

    private InductionProviderTier(BaseTier tier, FloatingLong out) {
        this.baseOutput = out;
        this.baseTier = tier;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public FloatingLong getOutput() {
        return this.outputReference == null ? this.getBaseOutput() : (FloatingLong)this.outputReference.getOrDefault();
    }

    public FloatingLong getBaseOutput() {
        return this.baseOutput;
    }

    public void setConfigReference(CachedFloatingLongValue outputReference) {
        this.outputReference = outputReference;
    }
}

